/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu.artisttable;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.tileentity.container.ArtistTableCanvasStorage;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CanvasCombination {
    public static final int[][] paintingShapes = new int[][]{{1, 1}, {1, 2}, {1, 3}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 2}, {4, 3}, {4, 4}};
    public final State state;
    public final Rectangle rectangle;
    @Nullable
    public final DummyCanvasData canvasData;

    public CanvasCombination(ArtistTableCanvasStorage canvasStorage, Level world) {
        Tuple min = null;
        Tuple max = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (canvasStorage.m_8020_(y * 4 + x) == ItemStack.f_41583_) continue;
                if (min == null) {
                    min = new Tuple((Object)x, (Object)y);
                }
                if (max == null) {
                    max = new Tuple((Object)x, (Object)y);
                    continue;
                }
                if ((Integer)max.m_14418_() < x) {
                    max = new Tuple((Object)x, (Object)((Integer)max.m_14419_()));
                }
                if ((Integer)max.m_14419_() >= y) continue;
                max = new Tuple((Object)((Integer)max.m_14418_()), (Object)y);
            }
        }
        if (min == null || max == null) {
            this.state = State.INVALID_SHAPE;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        boolean canvasesReady = true;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                ItemStack currentStack = canvasStorage.m_8020_(y * 4 + x);
                if (currentStack == ItemStack.f_41583_) {
                    if (x < (Integer)min.m_14418_() || x > (Integer)max.m_14418_() || y < (Integer)min.m_14419_() || y > (Integer)max.m_14419_()) continue;
                    this.state = State.INVALID_SHAPE;
                    this.rectangle = CanvasCombination.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (currentStack.m_41720_() != ZetterItems.CANVAS) continue;
                if (x < (Integer)min.m_14418_() || x > (Integer)max.m_14418_() || y < (Integer)min.m_14419_() || y > (Integer)max.m_14419_()) {
                    this.state = State.INVALID_SHAPE;
                    this.rectangle = CanvasCombination.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (CanvasItem.getCanvasData(currentStack, world) != null) continue;
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.CANVAS, CanvasItem.getCanvasCode(currentStack));
                canvasesReady = false;
            }
        }
        if (!canvasesReady) {
            this.state = State.NOT_LOADED;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        Rectangle rectangle = CanvasCombination.getRect(min, max);
        boolean shapeAvailable = false;
        for (int[] shape : paintingShapes) {
            if (rectangle.width != shape[0] || rectangle.height != shape[1]) continue;
            shapeAvailable = true;
        }
        if (!shapeAvailable) {
            this.state = State.INVALID_SHAPE;
            this.rectangle = CanvasCombination.getZeroRect();
            this.canvasData = null;
            return;
        }
        this.state = State.READY;
        this.rectangle = rectangle;
        this.canvasData = CanvasCombination.createCanvasData(canvasStorage, rectangle, world);
    }

    public static DummyCanvasData createCanvasData(ArtistTableCanvasStorage canvasStorage, Rectangle rectangle, Level world) {
        int pixelWidth = rectangle.width * Helper.getResolution().getNumeric();
        int pixelHeight = rectangle.height * Helper.getResolution().getNumeric();
        ByteBuffer color = ByteBuffer.allocate(pixelWidth * pixelHeight * 4);
        for (int slotY = rectangle.y; slotY < rectangle.y + rectangle.height; ++slotY) {
            for (int slotX = rectangle.x; slotX < rectangle.x + rectangle.width; ++slotX) {
                int colorIndex;
                int bigY;
                int bigX;
                int smallX;
                int smallY;
                ItemStack canvasStack = canvasStorage.m_8020_(slotY * 4 + slotX);
                CanvasData smallCanvasData = CanvasItem.getCanvasData(canvasStack, world);
                int relativeX = slotX - rectangle.x;
                int relativeY = slotY - rectangle.y;
                if (smallCanvasData != null) {
                    for (smallY = 0; smallY < smallCanvasData.getHeight(); ++smallY) {
                        for (smallX = 0; smallX < smallCanvasData.getWidth(); ++smallX) {
                            bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                            bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                            colorIndex = (bigY * pixelWidth + bigX) * 4;
                            color.putInt(colorIndex, smallCanvasData.getColorAt(smallX, smallY));
                        }
                    }
                    continue;
                }
                for (smallY = 0; smallY < Helper.getResolution().getNumeric(); ++smallY) {
                    for (smallX = 0; smallX < Helper.getResolution().getNumeric(); ++smallX) {
                        bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                        bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                        colorIndex = (bigY * pixelWidth + bigX) * 4;
                        color.putInt(colorIndex, Helper.CANVAS_COLOR);
                    }
                }
            }
        }
        DummyCanvasData combinedCanvasData = DummyCanvasData.createWrap(Helper.getResolution(), pixelWidth, pixelHeight, color.array());
        if (world.m_5776_()) {
            Helper.getWorldCanvasTracker(world).registerCanvasData("zetter_combined_canvas", combinedCanvasData);
        }
        return combinedCanvasData;
    }

    public static Rectangle getRect(Tuple<Integer, Integer> min, Tuple<Integer, Integer> max) {
        int width = (Integer)max.m_14418_() + 1 - (Integer)min.m_14418_();
        int height = (Integer)max.m_14419_() + 1 - (Integer)min.m_14419_();
        return new Rectangle((Integer)min.m_14418_(), (Integer)min.m_14419_(), width, height);
    }

    public static Rectangle getZeroRect() {
        return new Rectangle(0, 0, 0, 0);
    }

    public static enum State {
        INVALID_SHAPE,
        NOT_LOADED,
        READY;

    }

    private static class Rectangle {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

