/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu.painting;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.Vector;
import me.dantaeusb.zetter.menu.painting.PaintingFrame;

public class PaintingFrameBuffer {
    public static int FRAME_TIME_LIMIT = 500;
    private static final int MAX_FRAMES = 10;
    private static final int FRAME_SIZE = 11;
    public static final int BUFFER_SIZE = 110;
    private final ByteBuffer buffer;
    long frameStartTime;

    public PaintingFrameBuffer(long frameStartTime) {
        this.frameStartTime = frameStartTime;
        this.buffer = ByteBuffer.allocateDirect(110);
    }

    public PaintingFrameBuffer(long frameStartTime, ByteBuffer buffer) {
        this.frameStartTime = frameStartTime;
        this.buffer = buffer;
    }

    public boolean isEmpty() {
        return this.buffer.remaining() == 110;
    }

    public void updateStartFrameTime(long frameStartTime) throws Exception {
        if (!this.isEmpty()) {
            throw new Exception("Cannot update frame start time: PaintingFrameBuffer is not empty!");
        }
        this.frameStartTime = frameStartTime;
    }

    public boolean shouldBeSent(long currentTime) {
        return currentTime >= this.frameStartTime + (long)FRAME_TIME_LIMIT || this.buffer.position() == 110;
    }

    public void writeChange(long frameTime, int position, int color) {
        short timeOffset = (short)(frameTime - this.frameStartTime);
        this.buffer.put((byte)1);
        this.buffer.putShort(timeOffset);
        this.buffer.putInt(position);
        this.buffer.putInt(color);
    }

    public long getFrameStartTime() {
        return this.frameStartTime;
    }

    public ByteBuffer getBufferData() {
        this.buffer.flip();
        return this.buffer.asReadOnlyBuffer();
    }

    public Vector<PaintingFrame> getFrames(UUID ownerId) {
        Vector<PaintingFrame> list = new Vector<PaintingFrame>();
        int lastPosition = this.buffer.position();
        this.buffer.rewind();
        while (this.buffer.hasRemaining()) {
            byte flag = this.buffer.get();
            short timeOffset = this.buffer.getShort();
            int position = this.buffer.getInt();
            int color = this.buffer.getInt();
            if (flag != 1) break;
            long frameTime = this.frameStartTime + (long)timeOffset;
            PaintingFrame frame = new PaintingFrame(frameTime, position, color, ownerId);
            list.add(frame);
        }
        this.buffer.position(lastPosition);
        return list;
    }
}

