/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network;

import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.EaselContainerMenu;
import me.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.CUpdatePaintingPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import me.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class ServerHandler {
    public static void processFrameBuffer(CPaintingFrameBufferPacket packetIn, ServerPlayer sendingPlayer) {
        if (sendingPlayer.f_36096_ instanceof EaselContainerMenu) {
            EaselContainerMenu paintingContainer = (EaselContainerMenu)sendingPlayer.f_36096_;
            paintingContainer.processFrameBufferServer(packetIn.getFrameBuffer(), sendingPlayer.m_142081_());
        }
    }

    public static void processCanvasRequest(CCanvasRequestPacket packetIn, ServerPlayer sendingPlayer) {
        MinecraftServer server = sendingPlayer.m_183503_().m_142572_();
        ServerLevel world = server.m_129783_();
        CanvasServerTracker canvasTracker = (CanvasServerTracker)world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null);
        String canvasName = packetIn.getCanvasName();
        Zetter.LOG.debug("Got request to sync canvas " + packetIn.getCanvasName());
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.trackCanvas(sendingPlayer.m_142081_(), canvasName);
        AbstractCanvasData canvasData = packetIn.getCanvasType() == AbstractCanvasData.Type.CANVAS ? canvasTracker.getCanvasData(canvasName, CanvasData.class) : (packetIn.getCanvasType() == AbstractCanvasData.Type.PAINTING ? canvasTracker.getCanvasData(canvasName, PaintingData.class) : canvasTracker.getCanvasData(canvasName, DummyCanvasData.class));
        if (canvasData == null) {
            Zetter.LOG.error("Player " + sendingPlayer + " requested non-existent canvas: " + canvasName);
            return;
        }
        if (canvasData instanceof PaintingData) {
            SPaintingSyncMessage paintingSyncMessage = new SPaintingSyncMessage(canvasName, (PaintingData)canvasData, System.currentTimeMillis());
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)paintingSyncMessage);
        } else {
            SCanvasSyncMessage canvasSyncMessage = new SCanvasSyncMessage(canvasName, canvasData, System.currentTimeMillis());
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> sendingPlayer), (Object)canvasSyncMessage);
        }
    }

    public static void processUnloadRequest(CCanvasUnloadRequestPacket packetIn, ServerPlayer sendingPlayer) {
        MinecraftServer server = sendingPlayer.m_183503_().m_142572_();
        ServerLevel world = server.m_129783_();
        CanvasServerTracker canvasTracker = (CanvasServerTracker)world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null);
        Zetter.LOG.debug("Got request to unload canvas " + packetIn.getCanvasName());
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.stopTrackingCanvas(sendingPlayer.m_142081_(), packetIn.getCanvasName());
    }

    public static void processPaletteUpdate(CPaletteUpdatePacket packetIn, ServerPlayer sendingPlayer) {
        if (sendingPlayer.f_36096_ instanceof EaselContainerMenu) {
            EaselContainerMenu paintingContainer = (EaselContainerMenu)sendingPlayer.f_36096_;
            paintingContainer.setPaletteColor(packetIn.getSlotIndex(), packetIn.getColor());
        }
    }

    public static void processCreatePainting(CUpdatePaintingPacket packetIn, ServerPlayer sendingPlayer) {
        if (sendingPlayer.f_36096_ instanceof ArtistTableMenu) {
            ArtistTableMenu artistTableMenu = (ArtistTableMenu)sendingPlayer.f_36096_;
            artistTableMenu.updatePaintingName(packetIn.getPaintingName());
        }
    }

    public static void processBucketTool(CCanvasBucketToolPacket packetIn, ServerPlayer sendingPlayer) {
        if (sendingPlayer.f_36096_ instanceof EaselContainerMenu) {
            EaselContainerMenu easelContainer = (EaselContainerMenu)sendingPlayer.f_36096_;
            easelContainer.processBucketToolServer(packetIn.position, packetIn.color);
        }
    }
}

