/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasRequestPacket {
    private String canvasName;
    private AbstractCanvasData.Type type;

    public CCanvasRequestPacket() {
    }

    public CCanvasRequestPacket(AbstractCanvasData.Type type, String canvasName) {
        this.type = type;
        this.canvasName = canvasName;
    }

    public static CCanvasRequestPacket readPacketData(FriendlyByteBuf buf) {
        CCanvasRequestPacket packet = new CCanvasRequestPacket();
        packet.type = AbstractCanvasData.Type.values()[buf.readInt()];
        packet.canvasName = buf.m_130136_(Short.MAX_VALUE);
        return packet;
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.m_130070_(this.canvasName);
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public AbstractCanvasData.Type getCanvasType() {
        return this.type;
    }

    public static void handle(CCanvasRequestPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CRequestSyncPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCanvasRequest(packetIn, sendingPlayer));
    }
}

