/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import me.dantaeusb.zetter.network.packet.CanvasContainer;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CUpdatePaintingPacket {
    private int windowId;
    private String paintingName;
    private AbstractCanvasData canvasData;

    public CUpdatePaintingPacket() {
    }

    public CUpdatePaintingPacket(int windowId, String paintingName, AbstractCanvasData canvasData) {
        this.windowId = windowId;
        this.paintingName = paintingName;
        this.canvasData = canvasData;
    }

    public static CUpdatePaintingPacket readPacketData(FriendlyByteBuf buf) {
        CUpdatePaintingPacket packet = new CUpdatePaintingPacket();
        try {
            packet.windowId = buf.readByte();
            packet.paintingName = buf.m_130136_(Short.MAX_VALUE);
            packet.canvasData = CanvasContainer.readPacketCanvasData(buf);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading CCreatePaintingPacket: " + e);
            return packet;
        }
        return packet;
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.m_130070_(this.paintingName);
        CanvasContainer.writePacketCanvasData(buf, this.canvasData);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public String getPaintingName() {
        return this.paintingName;
    }

    public AbstractCanvasData getCanvasData() {
        return this.canvasData;
    }

    public static void handle(CUpdatePaintingPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCreatePaintingPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCreatePainting(packetIn, sendingPlayer));
    }
}

