/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.nio.ByteBuffer;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.network.FriendlyByteBuf;

public abstract class CanvasContainer {
    private static final AbstractCanvasData.Type[] typeValues = AbstractCanvasData.Type.values();

    public static AbstractCanvasData readPacketCanvasData(FriendlyByteBuf networkBuffer) {
        try {
            int type = networkBuffer.readInt();
            int resolutionOrdinal = networkBuffer.readInt();
            AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            int width = networkBuffer.readInt();
            int height = networkBuffer.readInt();
            int colorDataSize = networkBuffer.readInt();
            ByteBuffer colorData = networkBuffer.readBytes(colorDataSize).nioBuffer();
            byte[] unwrappedColorData = new byte[width * height * 4];
            colorData.get(unwrappedColorData);
            return switch (typeValues[type]) {
                case AbstractCanvasData.Type.CANVAS -> CanvasData.createWrap(resolution, width, height, unwrappedColorData);
                case AbstractCanvasData.Type.PAINTING -> PaintingData.createWrap(resolution, width, height, unwrappedColorData);
                default -> DummyCanvasData.createWrap(resolution, width, height, unwrappedColorData);
            };
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while extracting canvas from container: " + e);
            return null;
        }
    }

    public static void writePacketCanvasData(FriendlyByteBuf networkBuffer, AbstractCanvasData canvasData) {
        networkBuffer.writeInt(canvasData.getType().ordinal());
        networkBuffer.writeInt(canvasData.getResolution().ordinal());
        networkBuffer.writeInt(canvasData.getWidth());
        networkBuffer.writeInt(canvasData.getHeight());
        networkBuffer.writeInt(canvasData.getColorDataBuffer().remaining());
        networkBuffer.writeBytes(canvasData.getColorDataBuffer());
    }
}

