/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.network.packet.CanvasContainer;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SCanvasSyncMessage {
    private final String canvasCode;
    private final AbstractCanvasData canvasData;
    private final long timestamp;

    public SCanvasSyncMessage(String canvasCode, AbstractCanvasData canvasData, long timestamp) {
        this.canvasCode = canvasCode;
        this.canvasData = canvasData;
        this.timestamp = timestamp;
    }

    public String getCanvasCode() {
        return this.canvasCode;
    }

    public AbstractCanvasData getCanvasData() {
        return this.canvasData;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static SCanvasSyncMessage readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String canvasCode = networkBuffer.m_130277_();
            long timestamp = networkBuffer.readLong();
            AbstractCanvasData readCanvasData = CanvasContainer.readPacketCanvasData(networkBuffer);
            return new SCanvasSyncMessage(canvasCode, readCanvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncMessage: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130070_(this.canvasCode);
        networkBuffer.writeLong(this.timestamp);
        CanvasContainer.writePacketCanvasData(networkBuffer, this.canvasData);
    }

    public static void handle(SCanvasSyncMessage packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasSync(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SCanvasSyncMessage[canvas=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

