/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

@Deprecated
public class SEaselCanvasChangePacket {
    private int entityId;
    private ItemStack item;

    public SEaselCanvasChangePacket(int entityId, ItemStack item) {
        this.entityId = entityId;
        this.item = item.m_41777_();
    }

    public static SEaselCanvasChangePacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            byte windowId = networkBuffer.readByte();
            ItemStack item = networkBuffer.m_130267_();
            return new SEaselCanvasChangePacket(windowId, item);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SEaselCanvasChangePacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeByte(this.entityId);
        networkBuffer.m_130055_(this.item);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public static void handle(SEaselCanvasChangePacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SEaselCanvasChangePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processEaselCanvasUpdate(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SEaselCanvasChangePacket[windowId=" + this.entityId + ",stack=" + this.item + "]";
    }
}

