/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.Helper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.SavedData;

public abstract class AbstractCanvasData
extends SavedData {
    protected static final String NBT_TAG_TYPE = "type";
    protected static final String NBT_TAG_WIDTH = "width";
    protected static final String NBT_TAG_HEIGHT = "height";
    protected static final String NBT_TAG_RESOLUTION = "resolution";
    protected static final String NBT_TAG_COLOR = "color";
    protected byte[] color;
    protected ByteBuffer canvasBuffer;
    protected Resolution resolution;
    protected int width;
    protected int height;
    protected boolean managed = true;

    protected final void wrapData(Resolution resolution, int width, int height, byte[] color) {
        if (width % resolution.getNumeric() != 0 || height % resolution.getNumeric() != 0) {
            throw new IllegalArgumentException("Canvas size is not proportional to given canvas resolution");
        }
        this.resolution = resolution;
        this.width = width;
        this.height = height;
        this.updateColorData(color);
        this.m_77762_();
    }

    protected void updateColorData(byte[] color) {
        if (this.color != null && color.length != this.color.length) {
            throw new IllegalArgumentException("Color data size mismatch");
        }
        this.color = color;
        this.canvasBuffer = ByteBuffer.wrap(this.color);
        this.canvasBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public boolean updateCanvasPixel(int index, int color) {
        if (!this.isEditable()) {
            Zetter.LOG.warn("Tried to update sealed canvas " + this);
            return false;
        }
        this.canvasBuffer.putInt(index * 4, color);
        this.m_77762_();
        return true;
    }

    public int getColorAt(int pixelX, int pixelY) {
        return this.getColorAt(this.getPixelIndex(pixelX, pixelY));
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public abstract boolean isEditable();

    public abstract Type getType();

    public ByteBuffer getColorDataBuffer() {
        this.canvasBuffer.rewind();
        return this.canvasBuffer.asReadOnlyBuffer();
    }

    public int getColorAt(int index) {
        return this.canvasBuffer.getInt(index * 4);
    }

    public int getPixelIndex(int pixelX, int pixelY) {
        pixelX = Mth.m_14045_((int)pixelX, (int)0, (int)(this.width - 1));
        pixelY = Mth.m_14045_((int)pixelY, (int)0, (int)(this.height - 1));
        return pixelY * this.width + pixelX;
    }

    public void load(CompoundTag compoundTag) {
        this.width = compoundTag.m_128451_(NBT_TAG_WIDTH);
        this.height = compoundTag.m_128451_(NBT_TAG_HEIGHT);
        if (compoundTag.m_128441_(NBT_TAG_RESOLUTION)) {
            int resolutionOrdinal = compoundTag.m_128451_(NBT_TAG_RESOLUTION);
            this.resolution = Resolution.values()[resolutionOrdinal];
        } else {
            this.resolution = Helper.getResolution();
        }
        this.updateColorData(compoundTag.m_128463_(NBT_TAG_COLOR));
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128405_(NBT_TAG_TYPE, this.getType().ordinal());
        compoundTag.m_128405_(NBT_TAG_WIDTH, this.width);
        compoundTag.m_128405_(NBT_TAG_HEIGHT, this.height);
        compoundTag.m_128405_(NBT_TAG_RESOLUTION, this.resolution.ordinal());
        compoundTag.m_128382_(NBT_TAG_COLOR, this.color);
        return compoundTag;
    }

    public static enum Resolution {
        x16(16),
        x32(32),
        x64(64);

        private final int numeric;
        private static final Map<Integer, Resolution> lookup;

        private Resolution(int numeric) {
            this.numeric = numeric;
        }

        public int getNumeric() {
            return this.numeric;
        }

        @Nullable
        public static Resolution get(int numeric) {
            if (!lookup.containsKey(numeric)) {
                return null;
            }
            return lookup.get(numeric);
        }

        static {
            lookup = new HashMap<Integer, Resolution>();
            for (Resolution resolution : Resolution.values()) {
                lookup.put(resolution.getNumeric(), resolution);
            }
        }
    }

    public static enum Type {
        DUMMY,
        CANVAS,
        PAINTING;

    }
}

