/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.nbt.CompoundTag;

public class CanvasData
extends AbstractCanvasData {
    public static final String CODE_PREFIX = "zetter_canvas_";

    public static String getCanvasCode(int canvasId) {
        return CODE_PREFIX + canvasId;
    }

    protected CanvasData() {
    }

    public static CanvasData createFresh(AbstractCanvasData.Resolution resolution, int width, int height) {
        byte[] color = new byte[width * height * 4];
        ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
        for (int x = 0; x < width * height; ++x) {
            defaultColorBuffer.putInt(x * 4, Helper.CANVAS_COLOR);
        }
        CanvasData newCanvas = new CanvasData();
        newCanvas.wrapData(resolution, width, height, color);
        return newCanvas;
    }

    public static CanvasData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
        CanvasData newCanvas = new CanvasData();
        newCanvas.wrapData(resolution, width, height, color);
        return newCanvas;
    }

    public static CanvasData createLoaded(CompoundTag compoundTag) {
        CanvasData newCanvas = new CanvasData();
        newCanvas.load(compoundTag);
        return newCanvas;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public AbstractCanvasData.Type getType() {
        return AbstractCanvasData.Type.CANVAS;
    }
}

