/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.nbt.CompoundTag;

public class PaintingData
extends AbstractCanvasData {
    public static final String CODE_PREFIX = "zetter_painting_";
    protected static final String NBT_TAG_AUTHOR_NAME = "author_name";
    protected static final String NBT_TAG_TITLE = "title";
    public static final int MAX_GENERATION = 2;
    protected String authorName;
    protected String title;

    protected PaintingData() {
    }

    public static PaintingData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
        PaintingData newPainting = new PaintingData();
        newPainting.wrapData(resolution, width, height, color);
        return newPainting;
    }

    public static PaintingData createFrom(AbstractCanvasData templateCanvasData) {
        PaintingData newPainting = new PaintingData();
        newPainting.wrapData(templateCanvasData.getResolution(), templateCanvasData.getWidth(), templateCanvasData.getHeight(), templateCanvasData.color);
        return newPainting;
    }

    public static PaintingData createLoaded(CompoundTag compoundTag) {
        PaintingData newPainting = new PaintingData();
        newPainting.load(compoundTag);
        return newPainting;
    }

    public static String getCanvasCode(int canvasId) {
        return CODE_PREFIX + canvasId;
    }

    public void setMetaProperties(String authorName, String title) {
        this.authorName = authorName;
        this.title = title;
    }

    public String getPaintingName() {
        return this.title;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public static String getPaintingCode(int paintingId) {
        return CODE_PREFIX + paintingId;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public AbstractCanvasData.Type getType() {
        return AbstractCanvasData.Type.PAINTING;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        this.authorName = compoundTag.m_128461_(NBT_TAG_AUTHOR_NAME);
        this.title = compoundTag.m_128461_(NBT_TAG_TITLE);
    }

    @Override
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        super.m_7176_(compoundTag);
        compoundTag.m_128359_(NBT_TAG_AUTHOR_NAME, this.authorName);
        compoundTag.m_128359_(NBT_TAG_TITLE, this.title);
        return compoundTag;
    }
}

