/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.tileentity.container;

import java.util.function.Predicate;
import me.dantaeusb.zetter.core.ZetterItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ArtistTableCanvasStorage
implements Container {
    public static final int STORAGE_SIZE = 16;
    private final ItemStackHandler stackHandler;
    private Predicate<Player> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda = () -> {};
    private Notify openInventoryNotificationLambda = () -> {};
    private Notify closeInventoryNotificationLambda = () -> {};

    public static ArtistTableCanvasStorage createForTileEntity(Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new ArtistTableCanvasStorage(canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static ArtistTableCanvasStorage createForClientSideContainer() {
        return new ArtistTableCanvasStorage();
    }

    private ArtistTableCanvasStorage() {
        this.stackHandler = new ItemStackHandler(16){};
    }

    private ArtistTableCanvasStorage(Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this();
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public CompoundTag serializeNBT() {
        return this.stackHandler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stackHandler.deserializeNBT(nbt);
    }

    public void setCanPlayerAccessInventoryLambda(Predicate<Player> canPlayerAccessInventoryLambda) {
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
    }

    public void setMarkDirtyNotificationLambda(Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public void setOpenInventoryNotificationLambda(Notify openInventoryNotificationLambda) {
        this.openInventoryNotificationLambda = openInventoryNotificationLambda;
    }

    public void setCloseInventoryNotificationLambda(Notify closeInventoryNotificationLambda) {
        this.closeInventoryNotificationLambda = closeInventoryNotificationLambda;
    }

    public boolean m_6542_(Player player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (stack.m_41720_() == ZetterItems.CANVAS) {
            return this.stackHandler.isItemValid(index, stack);
        }
        return false;
    }

    public void m_6596_() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void m_5856_(Player player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void m_5785_(Player player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int m_6643_() {
        return this.stackHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            if (this.stackHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.stackHandler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.stackHandler.extractItem(index, count, false);
    }

    public ItemStack m_8016_(int index) {
        int maxPossibleItemStackSize = this.stackHandler.getSlotLimit(index);
        return this.stackHandler.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.stackHandler.setStackInSlot(index, stack);
    }

    public void m_6211_() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            this.stackHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

