/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.block;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.UnitMessenger;
import com.tm.calemicore.util.helper.ContainerHelper;
import com.tm.calemicore.util.helper.ItemHelper;
import com.tm.calemicore.util.helper.LoreHelper;
import com.tm.calemicore.util.helper.SoundHelper;
import com.tm.calemieconomy.block.base.BlockContainerBase;
import com.tm.calemieconomy.blockentity.BlockEntityBank;
import com.tm.calemieconomy.blockentity.BlockEntityTradingPost;
import com.tm.calemieconomy.init.InitBlockEntityTypes;
import com.tm.calemieconomy.init.InitItems;
import com.tm.calemieconomy.init.InitSounds;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockTradingPost
extends BlockContainerBase {
    public static final UnitMessenger MESSENGER = new UnitMessenger("trading_post");
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    public BlockTradingPost() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56736_).m_60978_(2.0f).m_60955_());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        LoreHelper.addInformationLoreFirst(tooltip, (MutableComponent)new TranslatableComponent("ce.lore.trading_post"));
        LoreHelper.addControlsLoreFirst(tooltip, (MutableComponent)new TranslatableComponent("ce.lore.trading_post.use"), (LoreHelper.ControlType)LoreHelper.ControlType.USE);
        LoreHelper.addControlsLore(tooltip, (MutableComponent)new TranslatableComponent("ce.lore.trading_post.use-wrench"), (LoreHelper.ControlType)LoreHelper.ControlType.USE);
        LoreHelper.addControlsLore(tooltip, (MutableComponent)new TranslatableComponent("ce.lore.trading_post.sneak-use"), (LoreHelper.ControlType)LoreHelper.ControlType.SNEAK_USE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Location location = new Location(level, pos);
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack walletStack = CurrencyHelper.getCurrentWallet(player);
        BlockEntity te = location.getBlockEntity();
        if (!(te instanceof BlockEntityTradingPost)) return InteractionResult.SUCCESS;
        BlockEntityTradingPost post = (BlockEntityTradingPost)te;
        if (!player.m_6047_() && heldStack.m_41720_() == InitItems.SECURITY_WRENCH.get()) {
            if (!post.adminMode) return super.m_6227_(state, level, pos, player, hand, hit);
            if (player.m_7500_()) {
                return super.m_6227_(state, level, pos, player, hand, hit);
            }
            if (level.m_5776_()) return InteractionResult.SUCCESS;
            MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.admin", new Object[0]), new Player[]{player});
            return InteractionResult.SUCCESS;
        } else if (!player.m_6047_() && !walletStack.m_41619_()) {
            this.handleTrade(level, player, post);
            return InteractionResult.SUCCESS;
        } else {
            if (level.m_5776_()) return InteractionResult.SUCCESS;
            if (post.hasValidTradeOffer) {
                MESSENGER.sendMessage((MutableComponent)post.getTradeInfo(false), new Player[]{player});
                MESSENGER.sendMessage(MESSENGER.getMessage("hold-wallet", new Object[0]), new Player[]{player});
                return InteractionResult.SUCCESS;
            } else {
                MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.invalid", new Object[0]), new Player[]{player});
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void handleTrade(Level level, Player player, BlockEntityTradingPost post) {
        BlockEntityBank bank = post.getBank();
        ItemStack walletStack = CurrencyHelper.getCurrentWallet(player);
        if (bank != null || post.tradePrice <= 0 || post.adminMode) {
            if (post.hasValidTradeOffer) {
                if (post.buyMode) {
                    this.handleSell(walletStack, level, player, post, bank);
                } else {
                    this.handlePurchase(walletStack, level, player, post, bank);
                }
            } else if (!level.m_5776_()) {
                MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.invalid", new Object[0]), new Player[]{player});
            }
        } else if (!level.m_5776_()) {
            MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.no-bank", new Object[0]), new Player[]{player});
        }
    }

    private void handleSell(ItemStack walletStack, Level level, Player player, BlockEntityTradingPost post, BlockEntityBank bank) {
        ItemWallet wallet = (ItemWallet)walletStack.m_41720_();
        if (ContainerHelper.countItems((Container)player.m_150109_(), (ItemStack)post.getStackForSale(), (boolean)true) >= post.tradeAmount) {
            ItemStack stackForSale = new ItemStack((ItemLike)post.getStackForSale().m_41720_(), post.tradeAmount);
            if (post.getStackForSale().m_41782_()) {
                stackForSale.m_41751_(post.getStackForSale().m_41783_());
            }
            if (ContainerHelper.canInsertStack((Container)post, (ItemStack)stackForSale) || post.adminMode) {
                if (wallet.canDepositCurrency(walletStack, post.tradePrice)) {
                    if (post.adminMode || post.tradePrice <= 0 || bank.canWithdrawCurrency(post.tradePrice)) {
                        ContainerHelper.consumeItems((Container)player.m_150109_(), (ItemStack)post.getStackForSale(), (int)post.tradeAmount, (boolean)true);
                        if (!post.adminMode) {
                            ContainerHelper.insertOverflowingStack((Container)post, (ItemStack)stackForSale);
                            bank.withdrawCurrency(post.tradePrice);
                        }
                        wallet.depositCurrency(walletStack, post.tradePrice);
                        SoundHelper.playAtPlayer((Player)player, (SoundEvent)((SoundEvent)InitSounds.COIN.get()), (float)0.1f, (float)1.0f);
                    } else if (!level.m_5776_()) {
                        MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.bank-empty", new Object[0]), new Player[]{player});
                    }
                } else if (!level.m_5776_()) {
                    MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.wallet-full", new Object[0]), new Player[]{player});
                }
            } else if (!level.m_5776_()) {
                MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.stock-full", new Object[0]), new Player[]{player});
            }
        } else if (!level.m_5776_()) {
            MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.no-items", new Object[0]), new Player[]{player});
        }
    }

    private void handlePurchase(ItemStack walletStack, Level level, Player player, BlockEntityTradingPost post, BlockEntityBank bank) {
        ItemWallet wallet = (ItemWallet)walletStack.m_41720_();
        if (post.getStock() >= post.tradeAmount || post.adminMode) {
            if (wallet.canWithdrawCurrency(walletStack, post.tradePrice)) {
                if (post.adminMode || post.tradePrice <= 0 || bank.canDepositCurrency(post.tradePrice)) {
                    ItemStack stackForSale = new ItemStack((ItemLike)post.getStackForSale().m_41720_(), post.tradeAmount);
                    if (post.getStackForSale().m_41782_()) {
                        stackForSale.m_41751_(post.getStackForSale().m_41783_());
                    }
                    if (!level.m_5776_()) {
                        ItemHelper.spawnOverflowingStackAtEntity((Level)player.m_183503_(), (Entity)player, (ItemStack)stackForSale);
                        if (!post.adminMode) {
                            bank.depositCurrency(post.tradePrice);
                        }
                        post.markUpdated();
                    }
                    wallet.withdrawCurrency(walletStack, post.tradePrice);
                    if (!post.adminMode) {
                        ContainerHelper.consumeItems((Container)post, (ItemStack)post.getStackForSale(), (int)post.tradeAmount, (boolean)true);
                    }
                    SoundHelper.playAtPlayer((Player)player, (SoundEvent)((SoundEvent)InitSounds.COIN.get()), (float)0.1f, (float)1.0f);
                } else if (!level.m_5776_()) {
                    MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.bank-full", new Object[0]), new Player[]{player});
                }
            } else if (!level.m_5776_()) {
                MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.wallet-empty", new Object[0]), new Player[]{player});
            }
        } else if (!level.m_5776_()) {
            MESSENGER.sendErrorMessage(MESSENGER.getMessage("error.stock-empty", new Object[0]), new Player[]{player});
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Location location;
        BlockEntity blockEntity;
        Player player;
        super.m_6402_(level, pos, state, placer, stack);
        if (placer instanceof Player && (player = (Player)placer).m_7500_() && !player.m_6047_() && (blockEntity = (location = new Location(level, pos)).getBlockEntity()) instanceof BlockEntityTradingPost) {
            BlockEntityTradingPost post = (BlockEntityTradingPost)blockEntity;
            post.adminMode = true;
            if (!level.m_5776_()) {
                MESSENGER.sendMessage(MESSENGER.getMessage("admin-mode", new Object[0]), new Player[]{player});
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)InitBlockEntityTypes.TRADING_POST.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockTradingPost.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)InitBlockEntityTypes.TRADING_POST.get()), BlockEntityTradingPost::tick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }
}

