/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.blockentity;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.blockentity.BlockEntityContainerBase;
import com.tm.calemieconomy.blockentity.ICurrencyNetwork;
import com.tm.calemieconomy.blockentity.ICurrencyNetworkUnit;
import com.tm.calemieconomy.config.CEConfig;
import com.tm.calemieconomy.init.InitBlockEntityTypes;
import com.tm.calemieconomy.item.ItemCoin;
import com.tm.calemieconomy.menu.MenuBank;
import com.tm.calemieconomy.security.ISecurityHolder;
import com.tm.calemieconomy.security.SecurityProfile;
import com.tm.calemieconomy.util.IBlockCurrencyHolder;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import com.tm.calemieconomy.util.helper.NetworkScanner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBank
extends BlockEntityContainerBase
implements ISecurityHolder,
IBlockCurrencyHolder,
ICurrencyNetwork {
    private final SecurityProfile profile = new SecurityProfile();
    private int currency;
    private boolean isOnlyConnectedBank = true;
    private NetworkScanner scanner;
    private final List<Location> connectedUnits = new ArrayList<Location>();

    public BlockEntityBank(BlockPos pos, BlockState state) {
        super((BlockEntityType)InitBlockEntityTypes.BANK.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntityBank bank) {
        BlockEntityBank.handleNetworkScan(level, bank);
        if (!bank.m_58904_().f_46443_) {
            BlockEntityBank.handleCoinInput(bank);
        }
    }

    private static void handleNetworkScan(Level level, BlockEntityBank bank) {
        if (bank.scanner == null) {
            bank.scanner = new NetworkScanner(bank.getLocation());
        }
        if (level.m_46467_() % 40L == 0L) {
            bank.getConnectedUnits().clear();
            boolean foundAnotherBank = false;
            bank.scanner.reset();
            bank.scanner.startNetworkScan(bank.getConnectedDirections());
            for (Location location : bank.scanner.buffer) {
                BlockEntity blockEntity;
                if (!location.equals((Object)bank.getLocation()) && location.getBlockEntity() instanceof BlockEntityBank) {
                    foundAnotherBank = true;
                }
                if (!((blockEntity = location.getBlockEntity()) instanceof ICurrencyNetworkUnit)) continue;
                ICurrencyNetworkUnit unit = (ICurrencyNetworkUnit)blockEntity;
                bank.getConnectedUnits().add(location);
                if (unit.getBankLocation() != null) continue;
                unit.setBankLocation(bank.getLocation());
            }
            bank.setOnlyConnectedBank(!foundAnotherBank);
        }
    }

    private static void handleCoinInput(BlockEntityBank bank) {
        ItemStack stack = bank.m_8020_(0);
        if (stack.m_41720_() instanceof ItemCoin) {
            int amountToAdd = ((ItemCoin)stack.m_41720_()).value;
            int countToRemove = 0;
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (!bank.canDepositCurrency(amountToAdd)) continue;
                amountToAdd += ((ItemCoin)stack.m_41720_()).value;
                ++countToRemove;
            }
            if (countToRemove != 0) {
                bank.depositCurrency(countToRemove * ((ItemCoin)stack.m_41720_()).value);
                bank.m_7407_(0, countToRemove);
            }
        }
    }

    public boolean isOnlyConnectedBank() {
        return this.isOnlyConnectedBank;
    }

    public void setOnlyConnectedBank(boolean value) {
        this.isOnlyConnectedBank = value;
        this.markUpdated();
    }

    public List<Location> getConnectedUnits() {
        return this.connectedUnits;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }

    @Override
    public int getCurrency() {
        return this.currency;
    }

    @Override
    public int getCurrencyCapacity() {
        return (Integer)CEConfig.economy.bankCurrencyCapacity.get();
    }

    @Override
    public void setCurrency(int amount) {
        this.currency = amount;
        this.markUpdated();
    }

    @Override
    public boolean canDepositCurrency(int amount) {
        return this.getCurrency() + amount <= this.getCurrencyCapacity();
    }

    @Override
    public boolean canWithdrawCurrency(int amount) {
        return this.getCurrency() >= amount;
    }

    @Override
    public void depositCurrency(int amount) {
        if (this.canDepositCurrency(amount)) {
            this.setCurrency(this.getCurrency() + amount);
        }
        this.markUpdated();
    }

    @Override
    public void withdrawCurrency(int amount) {
        if (this.canWithdrawCurrency(amount)) {
            this.setCurrency(this.getCurrency() - amount);
        }
        this.markUpdated();
    }

    @Override
    public Direction[] getConnectedDirections() {
        return Direction.values();
    }

    protected Component getDefaultName() {
        return new TranslatableComponent("container.bank");
    }

    public int m_6643_() {
        return 2;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory playerInv, Player player) {
        return new MenuBank(containerID, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.profile.loadFromNBT(tag);
        this.currency = CurrencyHelper.loadFromNBT(tag);
        this.isOnlyConnectedBank = tag.m_128471_("OnlyBank");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.profile.saveToNBT(tag);
        CurrencyHelper.saveToNBT(tag, this.currency);
        tag.m_128379_("OnlyBank", this.isOnlyConnectedBank);
    }
}

