/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.blockentity;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.blockentity.BlockEntityContainerBase;
import com.tm.calemicore.util.helper.LogHelper;
import com.tm.calemieconomy.blockentity.BlockEntityBank;
import com.tm.calemieconomy.blockentity.ICurrencyNetworkUnit;
import com.tm.calemieconomy.init.InitBlockEntityTypes;
import com.tm.calemieconomy.menu.MenuTradingPost;
import com.tm.calemieconomy.security.ISecurityHolder;
import com.tm.calemieconomy.security.SecurityProfile;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import com.tm.calemieconomy.util.helper.NetworkHelper;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTradingPost
extends BlockEntityContainerBase
implements ISecurityHolder,
ICurrencyNetworkUnit {
    private final SecurityProfile profile = new SecurityProfile();
    private Location bankLocation;
    private ItemStack stackForSale = ItemStack.f_41583_;
    public int tradeAmount = 1;
    public int tradePrice = 0;
    public boolean buyMode = false;
    public boolean adminMode = false;
    public boolean hasValidTradeOffer = false;
    public int broadcastDelay;

    public BlockEntityTradingPost(BlockPos pos, BlockState state) {
        super((BlockEntityType)InitBlockEntityTypes.TRADING_POST.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntityTradingPost post) {
        boolean bl = post.hasValidTradeOffer = post.getStackForSale() != null && !post.getStackForSale().m_41619_();
        if (!level.m_5776_() && post.broadcastDelay > 0 && level.m_46467_() % 20L == 0L) {
            --post.broadcastDelay;
        }
    }

    public ItemStack getStackForSale() {
        return this.stackForSale;
    }

    public void setStackForSale(ItemStack stack) {
        this.stackForSale = stack;
    }

    public int getStock() {
        if (this.getStackForSale() != null) {
            int count = 0;
            for (int i = 0; i < this.m_6643_(); ++i) {
                if (!ItemStack.m_41746_((ItemStack)this.m_8020_(i), (ItemStack)this.getStackForSale())) continue;
                if (this.getStackForSale().m_41782_()) {
                    if (!this.m_8020_(i).m_41782_() || !Objects.requireNonNull(this.m_8020_(i).m_41783_()).equals((Object)this.getStackForSale().m_41783_())) continue;
                    count += this.m_8020_(i).m_41613_();
                    continue;
                }
                count += this.m_8020_(i).m_41613_();
            }
            LogHelper.log((String)"Calemi's Economy", (Object)("STOCK: " + count));
            return count;
        }
        return 0;
    }

    public TextComponent getTradeInfo(boolean withLocation) {
        String msgKey = "ce.msg.trading_post.broadcast.";
        TextComponent message = new TextComponent("");
        if (this.adminMode) {
            message.m_7220_((Component)new TranslatableComponent(msgKey + "admin").m_130940_(ChatFormatting.GOLD));
        } else {
            message.m_130946_(ChatFormatting.GOLD + this.getSecurityProfile().getOwnerName());
        }
        message.m_130946_(ChatFormatting.AQUA + " ").m_7220_((Component)new TranslatableComponent(msgKey + "is").m_130946_(" "));
        message.m_7220_((Component)new TranslatableComponent(this.buyMode ? msgKey + "buying" : msgKey + "selling"));
        message.m_130946_(ChatFormatting.GOLD + " x").m_130946_(ChatFormatting.GOLD + String.valueOf(this.tradeAmount));
        message.m_130946_(" ").m_7220_(this.getStackForSale().m_41611_()).m_130946_(" ");
        message.m_7220_((Component)new TranslatableComponent(msgKey + "for").m_130946_(" "));
        message.m_7220_((Component)(this.tradePrice > 0 ? CurrencyHelper.formatCurrency(this.tradePrice).m_130940_(ChatFormatting.GOLD) : new TranslatableComponent(msgKey + "free").m_130940_(ChatFormatting.GOLD)));
        if (withLocation) {
            message.m_130946_(" ");
            message.m_7220_((Component)new TranslatableComponent(msgKey + "at").m_130946_(" "));
            message.m_130946_(ChatFormatting.GOLD + this.getLocation().toString());
        }
        return message;
    }

    @Override
    public SecurityProfile getSecurityProfile() {
        return this.profile;
    }

    @Override
    public Direction[] getConnectedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public BlockEntityBank getBank() {
        BlockEntityBank bank = NetworkHelper.getConnectedBank(this.getLocation(), this.bankLocation);
        if (bank == null) {
            this.bankLocation = null;
        }
        return bank;
    }

    @Override
    public Location getBankLocation() {
        return this.bankLocation;
    }

    @Override
    public void setBankLocation(Location location) {
        this.bankLocation = location;
    }

    protected Component getDefaultName() {
        return new TranslatableComponent("container.trading_post");
    }

    public int m_6643_() {
        return 27;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory playerInv, Player player) {
        return new MenuTradingPost(containerID, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.profile.loadFromNBT(tag);
        CompoundTag stackTag = tag.m_128469_("StackForSale");
        this.stackForSale = ItemStack.m_41712_((CompoundTag)stackTag);
        this.tradeAmount = tag.m_128451_("TradeAmount");
        this.tradePrice = tag.m_128451_("TradePrice");
        this.adminMode = tag.m_128471_("AdminMode");
        this.buyMode = tag.m_128471_("BuyMode");
        this.broadcastDelay = tag.m_128451_("BroadcastDelay");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.profile.saveToNBT(tag);
        CompoundTag stackTag = new CompoundTag();
        this.stackForSale.m_41739_(stackTag);
        tag.m_128365_("StackForSale", (Tag)stackTag);
        tag.m_128405_("TradeAmount", this.tradeAmount);
        tag.m_128405_("TradePrice", this.tradePrice);
        tag.m_128379_("AdminMode", this.adminMode);
        tag.m_128379_("BuyMode", this.buyMode);
        tag.m_128405_("BroadcastDelay", this.broadcastDelay);
    }
}

