/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.config;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CEConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final CategoryWorldGen worldGen = new CategoryWorldGen(COMMON_BUILDER);
    public static final CategoryEconomy economy = new CategoryEconomy(SERVER_BUILDER);
    public static final CategorySecurity security = new CategorySecurity(SERVER_BUILDER);
    public static final CategoryOverlay overlay = new CategoryOverlay(CLIENT_BUILDER);

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_BUILDER.build());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_BUILDER.build());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_BUILDER.build());
    }

    public static class CategoryWorldGen {
        public final ForgeConfigSpec.ConfigValue<Boolean> raritaniumOreGen;
        public final ForgeConfigSpec.ConfigValue<Integer> raritaniumVeinsPerChunk;
        public final ForgeConfigSpec.ConfigValue<Integer> raritaniumVeinSize;
        public final ForgeConfigSpec.ConfigValue<Integer> raritaniumOreGenMinY;
        public final ForgeConfigSpec.ConfigValue<Integer> raritaniumOreGenMaxY;

        public CategoryWorldGen(ForgeConfigSpec.Builder builder) {
            builder.push("WorldGen");
            this.raritaniumOreGen = builder.comment("Raritanium Ore Gen").define("raritaniumOreGen", true);
            this.raritaniumVeinsPerChunk = builder.comment("Raritanium Veins Per Chunk").define("raritaniumOreVeinsPerChunk", (Object)8);
            this.raritaniumVeinSize = builder.comment("Raritanium Vein Size").define("raritaniumVeinSize", (Object)8);
            this.raritaniumOreGenMinY = builder.comment("Raritanium Ore Min Y").define("raritaniumOreGenMinY", (Object)-60);
            this.raritaniumOreGenMaxY = builder.comment("Raritanium Ore Max Y").define("raritaniumOreGenMaxY", (Object)30);
            builder.pop();
        }
    }

    public static class CategoryEconomy {
        public final ForgeConfigSpec.ConfigValue<Integer> walletCurrencyCapacity;
        public final ForgeConfigSpec.ConfigValue<Integer> bankCurrencyCapacity;
        public final ForgeConfigSpec.ConfigValue<Boolean> tradingPostBroadcasts;
        public final ForgeConfigSpec.ConfigValue<Integer> tradingPostBroadcastDelay;
        public final ForgeConfigSpec.ConfigValue<Boolean> tradingPostOverlay;
        public final ForgeConfigSpec.ConfigValue<Integer> cheapMoneyBagMin;
        public final ForgeConfigSpec.ConfigValue<Integer> cheapMoneyBagMax;
        public final ForgeConfigSpec.ConfigValue<Integer> richMoneyBagMin;
        public final ForgeConfigSpec.ConfigValue<Integer> richMoneyBagMax;

        public CategoryEconomy(ForgeConfigSpec.Builder builder) {
            builder.push("Economy");
            this.walletCurrencyCapacity = builder.comment(new String[]{"Wallet Currency Capacity", "The max amount of currency the Wallet can store."}).defineInRange("walletCurrencyCapacity", 1000000, 0, 99999999);
            this.bankCurrencyCapacity = builder.comment(new String[]{"Bank Currency Capacity", "The max amount of currency the Bank can store."}).defineInRange("bankCurrencyCapacity", 1000000, 1, 99999999);
            this.tradingPostBroadcasts = builder.comment(new String[]{"Trading Post Broadcasts", "Disable this to disallow Players broadcasting their Trading Posts"}).define("tradingPostBroadcasts", true);
            this.tradingPostBroadcastDelay = builder.comment(new String[]{"Trading Post Broadcast Delay", "The amount of seconds before a Player can broadcasts their Trading Post."}).defineInRange("tradingPostBroadcastDelay", 10, 0, 3600);
            this.tradingPostOverlay = builder.comment(new String[]{"Trading Post Overlay", "Disable this to stop the screen overlay when selecting Trading Posts."}).define("tradingPostOverlay", true);
            this.cheapMoneyBagMin = builder.comment(new String[]{"Cheap Money Bag Minimum Coins Amount", "The minimum of the random amount of currency the Cheap Money Bag gives."}).defineInRange("cheapMoneyBagMin", 10, 0, 10000);
            this.cheapMoneyBagMax = builder.comment(new String[]{"Cheap Money Bag Maximum Coins Amount", "The maximum of the random amount of currency the Cheap Money Bag gives."}).defineInRange("cheapMoneyBagMax", 100, 0, 10000);
            this.richMoneyBagMin = builder.comment(new String[]{"Rich Money Bag Minimum Coins Amount", "The minimum of the random amount of currency the Rich Money Bag gives."}).defineInRange("richMoneyBagMin", 75, 0, 10000);
            this.richMoneyBagMax = builder.comment(new String[]{"Rich Money Bag Maximum Coins Amount", "The maximum of the random amount of currency the Rich Money Bag gives."}).defineInRange("richMoneyBagMax", 300, 0, 10000);
            builder.pop();
        }
    }

    public static class CategorySecurity {
        public final ForgeConfigSpec.ConfigValue<Boolean> useSecurity;

        public CategorySecurity(ForgeConfigSpec.Builder builder) {
            builder.push("Security");
            this.useSecurity = builder.comment(new String[]{"Use Security", "Disable this to allow everyone access to anyone's Blocks."}).define("useSecurity", true);
            builder.pop();
        }
    }

    public static class CategoryOverlay {
        public final ForgeConfigSpec.ConfigValue<Boolean> walletOverlay;
        public final ForgeConfigSpec.ConfigValue<String> walletOverlayPosition;

        public CategoryOverlay(ForgeConfigSpec.Builder builder) {
            builder.push("Overlay");
            this.walletOverlay = builder.comment(new String[]{"Render Wallet Currency Overlay", "Enable this render an overlay on your game screen showing your Wallet stats."}).define("walletOverlay", true);
            this.walletOverlayPosition = builder.comment(new String[]{"Wallet Currency Overlay Position", "The position of the screen of the Wallet overlay", "The valid values are {TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT}"}).define("walletOverlayPosition", (Object)WalletOverlayPosition.TOP_LEFT.toString());
            builder.pop();
        }
    }

    public static enum WalletOverlayPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final Map<String, WalletOverlayPosition> NAME_LOOKUP;

        @Nullable
        public static WalletOverlayPosition byName(@Nullable String name) {
            return name == null ? null : NAME_LOOKUP.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            NAME_LOOKUP = Arrays.stream(WalletOverlayPosition.values()).collect(Collectors.toMap(Enum::toString, n -> n));
        }
    }
}

