/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.event;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.blockentity.BlockEntityBase;
import com.tm.calemieconomy.blockentity.BlockEntityTradingPost;
import com.tm.calemieconomy.security.ISecurityHolder;
import com.tm.calemieconomy.util.helper.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SecurityEvents {
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (blockEntity instanceof BlockEntityBase) {
                BlockEntityBase blockEntityBase = (BlockEntityBase)blockEntity;
                if (blockEntity instanceof ISecurityHolder) {
                    ISecurityHolder securityHolder = (ISecurityHolder)blockEntity;
                    securityHolder.getSecurityProfile().setOwner(player);
                    blockEntityBase.markUpdated();
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Location location = new Location(event.getPlayer().m_183503_(), event.getPos());
        if (!event.getPlayer().m_7500_()) {
            if (!SecurityHelper.canEditSecuredBlock(location, event.getPlayer())) {
                event.setCanceled(true);
                SecurityHelper.printErrorMessage(location, event.getPlayer());
            } else {
                BlockEntity blockEntity = location.getBlockEntity();
                if (blockEntity instanceof BlockEntityTradingPost) {
                    BlockEntityTradingPost post = (BlockEntityTradingPost)blockEntity;
                    if (post.adminMode) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockExploded(ExplosionEvent event) {
        List affectedBlocks = event.getExplosion().m_46081_();
        ArrayList<BlockPos> securedBlocksFound = new ArrayList<BlockPos>();
        for (BlockPos pos : affectedBlocks) {
            BlockEntity blockEntity = event.getWorld().m_7702_(pos);
            if (!(blockEntity instanceof BlockEntityBase) || !(blockEntity instanceof ISecurityHolder)) continue;
            securedBlocksFound.add(pos);
        }
        affectedBlocks.removeAll(securedBlocksFound);
    }
}

