/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.helper.RayTraceHelper;
import com.tm.calemicore.util.helper.ScreenHelper;
import com.tm.calemieconomy.blockentity.BlockEntityTradingPost;
import com.tm.calemieconomy.config.CEConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TradingPostOverlayEvent {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderGameOverlayEvent.Post event) {
        if (!((Boolean)CEConfig.economy.tradingPostOverlay.get()).booleanValue()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            if (level != null && player != null) {
                Location hit;
                BlockEntity blockEntity;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                int midX = scaledWidth / 2;
                int midY = scaledHeight / 2;
                RayTraceHelper.BlockTrace blockTrace = RayTraceHelper.rayTraceBlock((Level)level, (Player)player, (int)5);
                if (blockTrace != null && (blockEntity = (hit = blockTrace.getHit()).getBlockEntity()) instanceof BlockEntityTradingPost) {
                    BlockEntityTradingPost post = (BlockEntityTradingPost)blockEntity;
                    if (post.hasValidTradeOffer) {
                        ItemStack stackForSale = post.getStackForSale();
                        MutableComponent postName = new TextComponent(post.getSecurityProfile().getOwnerName()).m_130946_("'s ").m_7220_((Component)new TranslatableComponent("unit.trading_post.name"));
                        TextComponent info = post.getTradeInfo(false);
                        ScreenHelper.drawTextBox((PoseStack)event.getMatrixStack(), (int)(midX - 3), (int)(midY + 12), (int)0, (boolean)true, (int)0xFFFFFF, (MutableComponent[])new MutableComponent[]{postName, info});
                    }
                }
            }
        }
    }
}

