/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.event;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.blockentity.BlockEntityBase;
import com.tm.calemicore.util.helper.ItemHelper;
import com.tm.calemieconomy.util.IBlockCurrencyHolder;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WrenchEvents {
    public static void onBlockWrenched(Location location) {
        IBlockCurrencyHolder currencyHolder;
        BlockEntity blockEntity = location.getBlockEntity();
        ItemStack stack = new ItemStack((ItemLike)location.getBlock().m_5456_(), 1);
        if (!location.level.m_5776_()) {
            ItemHelper.spawnStackAtLocation((Level)location.level, (Location)location, (ItemStack)stack);
        }
        if (blockEntity instanceof IBlockCurrencyHolder && (currencyHolder = (IBlockCurrencyHolder)blockEntity).getCurrency() > 0) {
            CompoundTag tag = stack.m_41784_();
            CurrencyHelper.saveToNBT(tag, currencyHolder.getCurrency());
            stack.m_41751_(tag);
        }
        location.setBlockToAir();
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
            if (blockEntity instanceof BlockEntityBase) {
                BlockEntityBase blockEntityBase = (BlockEntityBase)blockEntity;
                if (blockEntity instanceof IBlockCurrencyHolder) {
                    IBlockCurrencyHolder currencyHolder = (IBlockCurrencyHolder)blockEntity;
                    ItemStack mainStack = player.m_21120_(InteractionHand.MAIN_HAND);
                    ItemStack offStack = player.m_21120_(InteractionHand.OFF_HAND);
                    if (!this.transferCurrencyToBlock(mainStack, blockEntityBase, currencyHolder)) {
                        this.transferCurrencyToBlock(offStack, blockEntityBase, currencyHolder);
                    }
                }
            }
        }
    }

    private boolean transferCurrencyToBlock(ItemStack stack, BlockEntityBase blockEntity, IBlockCurrencyHolder currencyHolder) {
        if (stack.m_41720_() instanceof BlockItem) {
            int currency = CurrencyHelper.loadFromNBT(stack.m_41784_());
            if (currency != 0) {
                currencyHolder.setCurrency(currency);
                blockEntity.markUpdated();
            }
            return true;
        }
        return false;
    }
}

