/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.init;

import com.tm.calemieconomy.block.BlockBank;
import com.tm.calemieconomy.block.BlockCoinStack;
import com.tm.calemieconomy.block.BlockCurrencyNetworkCable;
import com.tm.calemieconomy.block.BlockCurrencyNetworkCableOpaque;
import com.tm.calemieconomy.block.BlockCurrencyNetworkGate;
import com.tm.calemieconomy.block.BlockRaritaniumOre;
import com.tm.calemieconomy.block.BlockTradingPost;
import com.tm.calemieconomy.block.base.BlockItemBase;
import com.tm.calemieconomy.item.ItemCoin;
import com.tm.calemieconomy.item.ItemMoneyBag;
import com.tm.calemieconomy.item.ItemSecurityWrench;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.main.CalemiEconomy;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class InitItems {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"calemieconomy");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"calemieconomy");
    public static final RegistryObject<Block> RARITANIUM_ORE = InitItems.regBlock("raritanium_ore", CalemiEconomy.TAB, () -> new BlockRaritaniumOre(MaterialColor.f_76409_, SoundType.f_56742_));
    public static final RegistryObject<Block> RARITANIUM_ORE_DEEPSLATE = InitItems.regBlock("raritanium_ore_deepslate", CalemiEconomy.TAB, () -> new BlockRaritaniumOre(MaterialColor.f_164534_, SoundType.f_154677_));
    public static final RegistryObject<Block> COIN_STACK_COPPER = BLOCKS.register("coin_stack_copper", BlockCoinStack::new);
    public static final RegistryObject<Block> COIN_STACK_SILVER = BLOCKS.register("coin_stack_silver", BlockCoinStack::new);
    public static final RegistryObject<Block> COIN_STACK_GOLD = BLOCKS.register("coin_stack_gold", BlockCoinStack::new);
    public static final RegistryObject<Block> COIN_STACK_PLATINUM = BLOCKS.register("coin_stack_platinum", BlockCoinStack::new);
    public static final RegistryObject<Block> CURRENCY_NETWORK_CABLE = InitItems.regBlock("currency_network_cable", CalemiEconomy.TAB, BlockCurrencyNetworkCable::new);
    public static final RegistryObject<Block> CURRENCY_NETWORK_CABLE_OPAQUE = InitItems.regBlock("currency_network_cable_opaque", CalemiEconomy.TAB, BlockCurrencyNetworkCableOpaque::new);
    public static final RegistryObject<Block> CURRENCY_NETWORK_GATE = InitItems.regBlock("currency_network_gate", CalemiEconomy.TAB, BlockCurrencyNetworkGate::new);
    public static final RegistryObject<Block> BANK = InitItems.regBlock("bank", CalemiEconomy.TAB, BlockBank::new);
    public static final RegistryObject<Block> TRADING_POST = InitItems.regBlock("trading_post", CalemiEconomy.TAB, BlockTradingPost::new);
    public static final RegistryObject<Item> RARITANIUM = InitItems.regItem("raritanium", () -> new Item(new Item.Properties().m_41491_(CalemiEconomy.TAB)));
    public static final RegistryObject<Item> COIN_COPPER = InitItems.regItem("coin_copper", () -> new ItemCoin(1, (Block)COIN_STACK_COPPER.get()));
    public static final RegistryObject<Item> COIN_SILVER = InitItems.regItem("coin_silver", () -> new ItemCoin(5, (Block)COIN_STACK_SILVER.get()));
    public static final RegistryObject<Item> COIN_GOLD = InitItems.regItem("coin_gold", () -> new ItemCoin(25, (Block)COIN_STACK_GOLD.get()));
    public static final RegistryObject<Item> COIN_PLATINUM = InitItems.regItem("coin_platinum", () -> new ItemCoin(100, (Block)COIN_STACK_PLATINUM.get()));
    public static final RegistryObject<Item> MONEY_BAG_CHEAP = InitItems.regItem("money_bag_cheap", () -> new ItemMoneyBag(false));
    public static final RegistryObject<Item> MONEY_BAG_RICH = InitItems.regItem("money_bag_rich", () -> new ItemMoneyBag(true));
    public static final RegistryObject<Item> WALLET = ITEMS.register("wallet", ItemWallet::new);
    public static final RegistryObject<Item> SECURITY_WRENCH = InitItems.regItem("security_wrench", ItemSecurityWrench::new);

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<Block> regBlock(String name, CreativeModeTab tab, Supplier<? extends Block> sup) {
        RegistryObject registryBlock = BLOCKS.register(name, sup);
        RegistryObject registryItem = ITEMS.register(name, () -> new BlockItemBase((Block)registryBlock.get(), tab));
        return registryBlock;
    }

    public static RegistryObject<Item> regItem(String name, Supplier<? extends Item> sup) {
        return ITEMS.register(name, sup);
    }
}

