/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.item;

import com.tm.calemicore.util.helper.ItemHelper;
import com.tm.calemicore.util.helper.LoreHelper;
import com.tm.calemicore.util.helper.MathHelper;
import com.tm.calemicore.util.helper.SoundHelper;
import com.tm.calemieconomy.config.CEConfig;
import com.tm.calemieconomy.init.InitItems;
import com.tm.calemieconomy.init.InitSounds;
import com.tm.calemieconomy.main.CalemiEconomy;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemMoneyBag
extends Item {
    private final boolean isRich;

    public ItemMoneyBag(boolean isRich) {
        super(new Item.Properties().m_41491_(CalemiEconomy.TAB));
        this.isRich = isRich;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipList, TooltipFlag advanced) {
        LoreHelper.addInformationLoreFirst(tooltipList, (MutableComponent)new TranslatableComponent("ce.lore.money_bag"));
        LoreHelper.addControlsLoreFirst(tooltipList, (MutableComponent)new TranslatableComponent("ce.lore.money_bag.use"), (LoreHelper.ControlType)LoreHelper.ControlType.USE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        stack.m_41774_(1);
        if (this.isRich) {
            SoundHelper.playAtPlayer((Player)player, (SoundEvent)((SoundEvent)InitSounds.MONEY_BAG_RICH.get()), (float)0.1f, (float)1.0f);
            this.giveCoins(level, player, (Integer)CEConfig.economy.cheapMoneyBagMin.get(), (Integer)CEConfig.economy.cheapMoneyBagMax.get());
        } else {
            SoundHelper.playAtPlayer((Player)player, (SoundEvent)((SoundEvent)InitSounds.MONEY_BAG_CHEAP.get()), (float)0.1f, (float)1.0f);
            this.giveCoins(level, player, (Integer)CEConfig.economy.richMoneyBagMin.get(), (Integer)CEConfig.economy.richMoneyBagMax.get());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void giveCoins(Level level, Player player, int minAmount, int maxAmount) {
        if (!level.m_5776_()) {
            int amount = minAmount + MathHelper.random.nextInt(maxAmount - minAmount);
            int dollars = (int)Math.floor((float)amount / 100.0f);
            int quarters = (int)Math.floor((float)(amount -= dollars * 100) / 25.0f);
            int nickels = (int)Math.floor((float)(amount -= quarters * 25) / 5.0f);
            int pennies = amount -= nickels * 5;
            ItemHelper.spawnStackAtEntity((Level)level, (Entity)player, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_PLATINUM.get(), dollars));
            ItemHelper.spawnStackAtEntity((Level)level, (Entity)player, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_GOLD.get(), quarters));
            ItemHelper.spawnStackAtEntity((Level)level, (Entity)player, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_SILVER.get(), nickels));
            ItemHelper.spawnStackAtEntity((Level)level, (Entity)player, (ItemStack)new ItemStack((ItemLike)InitItems.COIN_COPPER.get(), pennies));
        }
    }
}

