/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.item;

import com.tm.calemicore.util.UnitMessenger;
import com.tm.calemicore.util.helper.LoreHelper;
import com.tm.calemieconomy.config.CEConfig;
import com.tm.calemieconomy.curios.CuriosIntegration;
import com.tm.calemieconomy.main.CalemiEconomy;
import com.tm.calemieconomy.menu.MenuWallet;
import com.tm.calemieconomy.util.IItemCurrencyHolder;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemWallet
extends Item
implements IItemCurrencyHolder {
    public static final UnitMessenger MESSENGER = new UnitMessenger("wallet");

    public ItemWallet() {
        super(new Item.Properties().m_41491_(CalemiEconomy.TAB).m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> tooltipList, TooltipFlag advanced) {
        if (CalemiEconomy.isCuriosLoaded) {
            LoreHelper.addBlankLine(tooltipList);
        }
        LoreHelper.addInformationLoreFirst(tooltipList, (MutableComponent)new TranslatableComponent("ce.lore.wallet"));
        LoreHelper.addControlsLoreFirst(tooltipList, (MutableComponent)new TranslatableComponent("ce.lore.wallet.use"), (LoreHelper.ControlType)LoreHelper.ControlType.USE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if ((Integer)CEConfig.economy.walletCurrencyCapacity.get() > 0) {
                this.openGui(serverPlayer, stack, player.m_150109_().f_35977_);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void openGui(ServerPlayer player, ItemStack stack, int selectedSlot) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> new MenuWallet(id, playerInventory, stack), (Component)new TranslatableComponent("container.wallet")), buffer -> buffer.m_130055_(stack));
    }

    @Override
    public int getCurrency(ItemStack stack) {
        return CurrencyHelper.loadFromNBT(stack.m_41784_());
    }

    @Override
    public int getCurrencyCapacity() {
        return (Integer)CEConfig.economy.walletCurrencyCapacity.get();
    }

    @Override
    public void setCurrency(ItemStack stack, int amount) {
        CurrencyHelper.saveToNBT(stack.m_41784_(), amount);
    }

    @Override
    public boolean canDepositCurrency(ItemStack stack, int amount) {
        return this.getCurrency(stack) + amount <= this.getCurrencyCapacity();
    }

    @Override
    public boolean canWithdrawCurrency(ItemStack stack, int amount) {
        return this.getCurrency(stack) >= amount;
    }

    @Override
    public void depositCurrency(ItemStack stack, int amount) {
        if (this.canDepositCurrency(stack, amount)) {
            this.setCurrency(stack, this.getCurrency(stack) + amount);
        }
    }

    @Override
    public void withdrawCurrency(ItemStack stack, int amount) {
        if (this.canWithdrawCurrency(stack, amount)) {
            this.setCurrency(stack, this.getCurrency(stack) - amount);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CalemiEconomy.isCuriosLoaded) {
            return CuriosIntegration.walletCapability();
        }
        return super.initCapabilities(stack, nbt);
    }
}

