/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.packet;

import com.tm.calemicore.util.helper.ItemHelper;
import com.tm.calemieconomy.init.InitItems;
import com.tm.calemieconomy.item.ItemCoin;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.util.helper.CurrencyHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketExtractWalletCurrency {
    private int buttonId;
    private int multiplier;

    public PacketExtractWalletCurrency() {
    }

    public PacketExtractWalletCurrency(int buttonId, int multiplier) {
        this.buttonId = buttonId;
        this.multiplier = multiplier;
    }

    public PacketExtractWalletCurrency(FriendlyByteBuf buf) {
        this.buttonId = buf.readInt();
        this.multiplier = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.buttonId);
        buf.writeInt(this.multiplier);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Item patt1868$temp;
            ItemStack walletStack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (walletStack = CurrencyHelper.getCurrentWallet((Player)player)) != null && !walletStack.m_41619_() && (patt1868$temp = walletStack.m_41720_()) instanceof ItemWallet) {
                ItemWallet wallet = (ItemWallet)patt1868$temp;
                Item item = (Item)InitItems.COIN_COPPER.get();
                int price = ((ItemCoin)InitItems.COIN_COPPER.get()).value;
                if (this.buttonId == 1) {
                    item = (Item)InitItems.COIN_SILVER.get();
                    price = ((ItemCoin)InitItems.COIN_SILVER.get()).value;
                } else if (this.buttonId == 2) {
                    item = (Item)InitItems.COIN_GOLD.get();
                    price = ((ItemCoin)InitItems.COIN_GOLD.get()).value;
                } else if (this.buttonId == 3) {
                    item = (Item)InitItems.COIN_PLATINUM.get();
                    price = ((ItemCoin)InitItems.COIN_PLATINUM.get()).value;
                }
                wallet.withdrawCurrency(walletStack, price *= this.multiplier);
                ItemHelper.spawnStackAtEntity((Level)player.m_183503_(), (Entity)player, (ItemStack)new ItemStack((ItemLike)item, this.multiplier));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

