/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.packet;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.helper.ChatHelper;
import com.tm.calemieconomy.block.BlockTradingPost;
import com.tm.calemieconomy.blockentity.BlockEntityTradingPost;
import com.tm.calemieconomy.config.CEConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketTradingPost {
    private String command;
    private BlockPos pos;
    private ItemStack stackForSale;
    private boolean buyMode;
    private int tradeAmount;
    private int tradePrice;

    public PacketTradingPost() {
    }

    public PacketTradingPost(String command, BlockPos pos, ItemStack stackForSale, boolean buyMode, int tradeAmount, int tradePrice) {
        this.command = command;
        this.pos = pos;
        this.stackForSale = stackForSale;
        this.buyMode = buyMode;
        this.tradeAmount = tradeAmount;
        this.tradePrice = tradePrice;
    }

    public PacketTradingPost(String command, BlockPos pos) {
        this(command, pos, ItemStack.f_41583_, false, 0, 0);
    }

    public PacketTradingPost(String command, BlockPos pos, boolean buyMode) {
        this(command, pos, ItemStack.f_41583_, buyMode, 0, 0);
    }

    public PacketTradingPost(String command, BlockPos pos, ItemStack stack) {
        this(command, pos, stack, false, 0, 0);
    }

    public PacketTradingPost(String command, BlockPos pos, int tradeAmount, int tradePrice) {
        this(command, pos, ItemStack.f_41583_, false, tradeAmount, tradePrice);
    }

    public PacketTradingPost(FriendlyByteBuf buf) {
        this.command = buf.m_130136_(11).trim();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.stackForSale = buf.m_130267_();
        this.buyMode = buf.readBoolean();
        this.tradeAmount = buf.readInt();
        this.tradePrice = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130072_(this.command, 11);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.m_130055_(this.stackForSale);
        buf.writeBoolean(this.buyMode);
        buf.writeInt(this.tradeAmount);
        buf.writeInt(this.tradePrice);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Location location;
            BlockEntity patt3559$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (patt3559$temp = (location = new Location((Level)player.m_183503_(), this.pos)).getBlockEntity()) instanceof BlockEntityTradingPost) {
                BlockEntityTradingPost post = (BlockEntityTradingPost)patt3559$temp;
                if (this.command.equalsIgnoreCase("broadcast")) {
                    if (post.hasValidTradeOffer) {
                        if (post.broadcastDelay <= 0) {
                            ChatHelper.broadcastMessage((Level)player.m_183503_(), (MutableComponent)post.getTradeInfo(true));
                            post.broadcastDelay = (Integer)CEConfig.economy.tradingPostBroadcastDelay.get();
                        } else {
                            BlockTradingPost.MESSENGER.sendErrorMessage(BlockTradingPost.MESSENGER.getMessage("error.wait", new Object[]{post.broadcastDelay}), new Player[]{player});
                        }
                    } else {
                        BlockTradingPost.MESSENGER.sendErrorMessage(BlockTradingPost.MESSENGER.getMessage("error.invalid", new Object[0]), new Player[]{player});
                    }
                }
                if (this.command.equalsIgnoreCase("syncmode")) {
                    post.buyMode = this.buyMode;
                } else if (this.command.equalsIgnoreCase("syncstack")) {
                    post.setStackForSale(this.stackForSale);
                } else if (this.command.equalsIgnoreCase("syncoptions")) {
                    post.tradeAmount = this.tradeAmount;
                    post.tradePrice = this.tradePrice;
                }
                post.markUpdated();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

