/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemieconomy.util.helper;

import com.tm.calemicore.util.helper.StringHelper;
import com.tm.calemieconomy.init.InitItems;
import com.tm.calemieconomy.item.ItemWallet;
import com.tm.calemieconomy.main.CalemiEconomy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class CurrencyHelper {
    public static ItemStack getCurrentWallet(Player player) {
        if (player.m_21205_().m_41720_() instanceof ItemWallet) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() instanceof ItemWallet) {
            return player.m_21206_();
        }
        if (CalemiEconomy.isCuriosLoaded && CuriosApi.getCuriosHelper().findEquippedCurio((Item)InitItems.WALLET.get(), (LivingEntity)player).isPresent()) {
            return (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)InitItems.WALLET.get()), (LivingEntity)player).get()).right;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ItemWallet)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static MutableComponent formatCurrency(int amount) {
        return new TextComponent(StringHelper.insertCommas((int)amount)).m_7220_((Component)new TranslatableComponent("ce.rc"));
    }

    public static void addCurrencyLore(List<Component> tooltip, int currentCurrency) {
        CurrencyHelper.addCurrencyLore(tooltip, currentCurrency, 0);
    }

    public static void addCurrencyLore(List<Component> tooltip, int currentCurrency, int maxCurrency) {
        MutableComponent amount = CurrencyHelper.formatCurrency(currentCurrency);
        if (maxCurrency > 0) {
            amount.m_130946_(" / ").m_7220_((Component)CurrencyHelper.formatCurrency(maxCurrency));
        }
        tooltip.add((Component)new TranslatableComponent("lore.currency").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)amount.m_130940_(ChatFormatting.GOLD)));
    }

    public static int loadFromNBT(CompoundTag tag) {
        CompoundTag currencyTag = tag.m_128469_("Currency");
        return currencyTag.m_128451_("Amount");
    }

    public static void saveToNBT(CompoundTag tag, int amount) {
        CompoundTag currencyTag = new CompoundTag();
        currencyTag.m_128405_("Amount", amount);
        tag.m_128365_("Currency", (Tag)currencyTag);
    }
}

