/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common;

import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.colytra.common.ElytraTag;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class CommonEventHandler {
    public static final AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("668bdbee-32b6-4c4b-bf6a-5a30f4d02e37"), "Flight modifier", 1.0, AttributeModifier.Operation.ADDITION);

    private static void updateColytra(ItemStack chestStack, Player player) {
        ItemStack elytraStack = ElytraTag.getElytra(chestStack);
        int fallFlyTicks = player.m_21256_();
        if ((fallFlyTicks + 1) % 20 != 0) {
            return;
        }
        ElytraTag.damageElytra((LivingEntity)player, chestStack, elytraStack, 1);
    }

    private static void handleColytraMending(ItemStack chestStack, PlayerXpEvent.PickupXp evt, Player player) {
        ItemStack elytraStack = ElytraTag.getElytra(chestStack);
        if (elytraStack.m_41619_() || elytraStack.m_41773_() <= 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)elytraStack) <= 0) {
            return;
        }
        ExperienceOrb xpOrb = evt.getOrb();
        if (player.f_36101_ == 0) {
            int i = Math.min(CommonEventHandler.xpToDurability(xpOrb.f_20770_), elytraStack.m_41773_());
            if (i <= 0) {
                return;
            }
            evt.setCanceled(true);
            player.f_36101_ = 2;
            player.m_7938_((Entity)xpOrb, 1);
            xpOrb.f_20770_ -= CommonEventHandler.durabilityToXp(i);
            elytraStack.m_41721_(elytraStack.m_41773_() - i);
            ElytraTag.setElytra(chestStack, elytraStack);
            if (xpOrb.f_20770_ > 0) {
                player.m_6756_(xpOrb.f_20770_);
            }
            xpOrb.m_146870_();
        }
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static void handleColytraRepair(ItemStack chestStack, AnvilUpdateEvent evt) {
        ItemStack stack = ElytraTag.getElytra(chestStack);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack right = evt.getRight();
        int toRepair = stack.m_41773_();
        if (right.m_41720_() != Items.f_42714_ || toRepair == 0) {
            return;
        }
        int membraneToUse = 0;
        while (toRepair > 0) {
            toRepair -= 108;
            ++membraneToUse;
        }
        membraneToUse = Math.min(membraneToUse, right.m_41613_());
        int newDamage = Math.max(stack.m_41773_() - membraneToUse * 108, 0);
        ItemStack output = chestStack.m_41777_();
        ItemStack outputElytra = stack.m_41777_();
        outputElytra.m_41721_(newDamage);
        outputElytra.m_41742_(stack.m_41610_() * 2 + 1);
        ElytraTag.setElytra(output, outputElytra);
        int xpCost = membraneToUse + chestStack.m_41610_() + right.m_41610_();
        String name = evt.getName();
        if (name != null && !name.isEmpty() && !name.equals(chestStack.m_41786_().getString())) {
            output.m_41714_((Component)new TextComponent(name));
            ++xpCost;
        }
        evt.setMaterialCost(membraneToUse);
        evt.setCost(xpCost);
        evt.setOutput(output);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side != LogicalSide.SERVER || evt.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = evt.player;
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        if (attributeInstance != null) {
            attributeInstance.m_22130_(FLIGHT_MODIFIER);
            if (ElytraTag.isUseable(stack, ElytraTag.getElytra(stack))) {
                attributeInstance.m_22118_(FLIGHT_MODIFIER);
                if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.PERFECT) {
                    CommonEventHandler.updateColytra(stack, player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerXpEvent.PickupXp evt) {
        if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
            return;
        }
        Player player = evt.getPlayer();
        if (player.f_19853_.f_46443_) {
            return;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        CommonEventHandler.handleColytraMending(stack, evt, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onColytraAnvil(AnvilUpdateEvent evt) {
        if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
            return;
        }
        ItemStack left = evt.getLeft();
        CommonEventHandler.handleColytraRepair(left, evt);
    }
}

