/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityStraddler;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityStradpole
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DESPAWN_SOON = SynchedEntityData.m_135353_(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAUNCHED = SynchedEntityData.m_135353_(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public float swimPitch = 0.0f;
    public float prevSwimPitch = 0.0f;
    private int despawnTimer = 0;
    private int ricochetCount = 0;

    protected EntityStradpole(EntityType type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.f_21342_ = new AquaticMoveController((PathfinderMob)this, 1.4f);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    public int m_5792_() {
        return 2;
    }

    @Nonnull
    public ItemStack m_142563_() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.STRADPOLE_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void m_142146_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == AMItemRegistry.MOSQUITO_LARVA.get()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.nextFloat() < 0.45f) {
                EntityStraddler straddler = (EntityStraddler)((EntityType)AMEntityRegistry.STRADDLER.get()).m_20615_(this.f_19853_);
                straddler.m_20359_((Entity)this);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)straddler);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemstack.m_41720_() == Items.f_42448_ && this.m_6084_()) {
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            ItemStack itemstack1 = this.m_142563_();
            this.m_142146_(itemstack1);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.m_21008_(hand, itemstack2);
            Level level = this.f_19853_;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(DESPAWN_SOON, (Object)false);
        this.f_19804_.m_135372_(LAUNCHED, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public boolean m_142392_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_142139_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getParentId() != null) {
            compound.m_128362_("ParentUUID", this.getParentId());
        }
        compound.m_128379_("FromBucket", this.m_142392_());
        compound.m_128379_("DespawnSoon", this.isDespawnSoon());
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_142392_();
    }

    public boolean m_6785_(double p_27492_) {
        return !this.m_142392_() && !this.m_8077_();
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.stradpoleSpawnRolls, this.m_21187_(), spawnReasonIn);
    }

    public static boolean canStradpoleSpawn(EntityType<EntityStradpole> p_234314_0_, LevelAccessor p_234314_1_, MobSpawnType p_234314_2_, BlockPos p_234314_3_, Random p_234314_4_) {
        if (p_234314_1_.m_6425_(p_234314_3_).m_76153_((Tag)FluidTags.f_13132_) && !p_234314_1_.m_6425_(p_234314_3_.m_7495_()).m_76153_((Tag)FluidTags.f_13132_)) {
            return p_234314_1_.m_46859_(p_234314_3_.m_7494_());
        }
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ParentUUID")) {
            this.setParentId(compound.m_128342_("ParentUUID"));
        }
        this.m_142139_(compound.m_128471_("FromBucket"));
        this.setDespawnSoon(compound.m_128471_("DespawnSoon"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new StradpoleAISwim(this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        if (!worldIn.m_8055_(pos).m_60819_().m_76178_()) {
            return 15.0f;
        }
        return Float.NEGATIVE_INFINITY;
    }

    public boolean isDespawnSoon() {
        return (Boolean)this.f_19804_.m_135370_(DESPAWN_SOON);
    }

    public void setDespawnSoon(boolean despawnSoon) {
        this.f_19804_.m_135381_(DESPAWN_SOON, (Object)despawnSoon);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new BoneSerpentPathNavigator((Mob)this, worldIn);
    }

    public void m_8119_() {
        float f2;
        float f = 1.0f;
        if (((Boolean)this.f_19804_.m_135370_(LAUNCHED)).booleanValue()) {
            this.f_20883_ = this.m_146908_();
            HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, this::canHitEntity);
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
                this.onImpact(raytraceresult);
            }
            f = 0.1f;
        }
        super.m_8119_();
        boolean liquid = this.m_20069_() || this.m_20077_();
        this.prevSwimPitch = this.swimPitch;
        this.swimPitch = f2 = (float)(-((double)((float)this.m_20184_().f_82480_ * (liquid ? 2.5f : f)) * 57.2957763671875));
        if (this.f_19861_ && !this.m_20069_() && !this.m_20077_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
            this.f_19861_ = false;
            this.f_19812_ = true;
        }
        this.m_20242_(false);
        if (liquid) {
            this.m_20242_(true);
        }
        if (this.isDespawnSoon()) {
            ++this.despawnTimer;
            if (this.despawnTimer > 100) {
                this.despawnTimer = 0;
                this.m_21373_();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void onImpact(HitResult raytraceresult) {
        BlockHitResult traceResult;
        BlockState blockstate;
        HitResult.Type raytraceresult$type = raytraceresult.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)raytraceresult);
        } else if (raytraceresult$type == HitResult.Type.BLOCK && !(blockstate = this.f_19853_.m_8055_((traceResult = (BlockHitResult)raytraceresult).m_82425_())).m_60816_((BlockGetter)this.f_19853_, traceResult.m_82425_()).m_83281_()) {
            Direction face = traceResult.m_82434_();
            Vec3 prevMotion = this.m_20184_();
            double motionX = prevMotion.m_7096_();
            double motionY = prevMotion.m_7098_();
            double motionZ = prevMotion.m_7094_();
            switch (face) {
                case EAST: 
                case WEST: {
                    motionX = -motionX;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    motionZ = -motionZ;
                    break;
                }
                default: {
                    motionY = -motionY;
                }
            }
            this.m_20334_(motionX, motionY, motionZ);
            if (this.f_19797_ > 200 || this.ricochetCount > 20) {
                this.f_19804_.m_135381_(LAUNCHED, (Object)false);
            } else {
                ++this.ricochetCount;
            }
        }
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    private void onEntityHit(EntityHitResult raytraceresult) {
        Entity entity = this.getParent();
        if (entity instanceof LivingEntity && !this.f_19853_.f_46443_ && raytraceresult.m_82443_() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)raytraceresult.m_82443_();
            target.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)entity)).m_19366_(), 3.0f);
            target.m_147240_((double)0.7f, entity.m_20185_() - this.m_20185_(), entity.m_20189_() - this.m_20189_());
            this.f_19804_.m_135381_(LAUNCHED, (Object)false);
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        return !p_230298_1_.m_5833_() && !(p_230298_1_ instanceof EntityStraddler) && !(p_230298_1_ instanceof EntityStradpole);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_7479_(Fluid p_230285_1_) {
        return p_230285_1_.m_76108_((Tag)FluidTags.f_13132_);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && (this.m_20069_() || this.m_20077_())) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_6229_(int p_209207_1_) {
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3 lvt_9_1_ = new Vec3(p_70186_1_, p_70186_3_, p_70186_5_).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_).m_82490_((double)p_70186_7_);
        this.m_20256_(lvt_9_1_);
        float lvt_10_1_ = (float)lvt_9_1_.m_165925_();
        this.m_146922_((float)(Mth.m_14136_((double)lvt_9_1_.f_82479_, (double)lvt_9_1_.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)lvt_9_1_.f_82480_, (double)lvt_10_1_) * 57.2957763671875));
        this.f_19860_ = this.m_146909_();
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        this.f_20886_ = this.m_146908_();
        this.f_19859_ = this.m_146908_();
        this.setDespawnSoon(true);
        this.f_19804_.m_135381_(LAUNCHED, (Object)true);
    }

    class StradpoleAISwim
    extends RandomStrollGoal {
        public StradpoleAISwim(EntityStradpole creature, double speed, int chance) {
            super((PathfinderMob)creature, speed, chance, false);
        }

        public boolean m_8036_() {
            if (!this.f_25725_.m_20077_() && !this.f_25725_.m_20069_() || this.f_25725_.m_20159_() || this.f_25725_.m_5448_() != null || !this.f_25725_.m_20069_() && !this.f_25725_.m_20077_() && this.f_25725_ instanceof ISemiAquatic && !((ISemiAquatic)this.f_25725_).shouldEnterWater()) {
                return false;
            }
            if (!this.f_25731_ && this.f_25725_.m_21187_().nextInt(this.f_25730_) != 0) {
                return false;
            }
            Vec3 vector3d = this.m_7037_();
            if (vector3d == null) {
                return false;
            }
            this.f_25726_ = vector3d.f_82479_;
            this.f_25727_ = vector3d.f_82480_;
            this.f_25728_ = vector3d.f_82481_;
            this.f_25731_ = false;
            return true;
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vector3d;
            if (this.f_25725_.m_21187_().nextFloat() < 0.3f && (vector3d = this.findSurfaceTarget(this.f_25725_, 15, 7)) != null) {
                return vector3d;
            }
            vector3d = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)7, (int)3);
            int i = 0;
            while (vector3d != null && !this.f_25725_.f_19853_.m_6425_(new BlockPos(vector3d)).m_76153_((Tag)FluidTags.f_13132_) && !this.f_25725_.f_19853_.m_8055_(new BlockPos(vector3d)).m_60647_((BlockGetter)this.f_25725_.f_19853_, new BlockPos(vector3d), PathComputationType.WATER) && i++ < 15) {
                vector3d = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            }
            return vector3d;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.m_142082_(dx * scale, 0, dz * scale);
            return this.f_25725_.f_19853_.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13132_) || this.f_25725_.f_19853_.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_) && !this.f_25725_.f_19853_.m_8055_(blockpos).m_60767_().m_76334_();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.f_25725_.f_19853_.m_8055_(pos.m_142082_(dx * scale, 1, dz * scale)).m_60795_() && this.f_25725_.f_19853_.m_8055_(pos.m_142082_(dx * scale, 2, dz * scale)).m_60795_();
        }

        private Vec3 findSurfaceTarget(PathfinderMob creature, int i, int i1) {
            BlockPos upPos = creature.m_142538_();
            while (creature.f_19853_.m_6425_(upPos).m_76153_((Tag)FluidTags.f_13131_) || creature.f_19853_.m_6425_(upPos).m_76153_((Tag)FluidTags.f_13132_)) {
                upPos = upPos.m_7494_();
            }
            if (this.isAirAbove(upPos.m_7495_(), 0, 0, 0) && this.canJumpTo(upPos.m_7495_(), 0, 0, 0)) {
                return new Vec3((double)((float)upPos.m_123341_() + 0.5f), (double)((float)upPos.m_123342_() - 1.0f), (double)((float)upPos.m_123343_() + 0.5f));
            }
            return null;
        }
    }
}

