/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.config.BiomeConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.world.FeatureLeafcutterAnthill;
import com.github.alexthe666.citadel.config.biome.SpawnBiomeData;
import com.github.alexthe666.citadel.server.generation.GenerationSettingsManager;
import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="alexsmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AMWorldRegistry {
    public static final Feature<NoneFeatureConfiguration> LEAFCUTTER_ANTHILL = new FeatureLeafcutterAnthill((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static ConfiguredFeature<?, ?> LEAFCUTTER_ANTHILL_CF;
    public static PlacedFeature LEAFCUTTER_ANTHILL_PF;
    public static boolean initBiomes;

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(LEAFCUTTER_ANTHILL);
        LEAFCUTTER_ANTHILL_CF = (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("alexsmobs:leafcutter_anthill"), (Object)LEAFCUTTER_ANTHILL.m_65815_((FeatureConfiguration)FeatureConfiguration.f_67737_));
        LEAFCUTTER_ANTHILL_PF = (PlacedFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("alexsmobs:leafcutter_anthill"), (Object)LEAFCUTTER_ANTHILL_CF.m_190823_(new PlacementModifier[0]));
    }

    public static void onBiomesLoad(BiomeLoadingEvent event) {
        initBiomes = true;
        if (AMWorldRegistry.testBiome(BiomeConfig.grizzlyBear, event.getCategory(), event.getName()) && AMConfig.grizzlyBearSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GRIZZLY_BEAR.get(), AMConfig.grizzlyBearSpawnWeight, 2, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.roadrunner, event.getCategory(), event.getName()) && AMConfig.roadrunnerSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ROADRUNNER.get(), AMConfig.roadrunnerSpawnWeight, 2, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.boneSerpent, event.getCategory(), event.getName()) && AMConfig.boneSerpentSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.BONE_SERPENT.get(), AMConfig.boneSerpentSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.gazelle, event.getCategory(), event.getName()) && AMConfig.gazelleSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GAZELLE.get(), AMConfig.gazelleSpawnWeight, 7, 7));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.crocodile, event.getCategory(), event.getName()) && AMConfig.crocodileSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CROCODILE.get(), AMConfig.crocodileSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.fly, event.getCategory(), event.getName()) && AMConfig.flySpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.FLY.get(), AMConfig.flySpawnWeight, 2, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.hummingbird, event.getCategory(), event.getName()) && AMConfig.hummingbirdSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.HUMMINGBIRD.get(), AMConfig.hummingbirdSpawnWeight, 7, 7));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.orca, event.getCategory(), event.getName()) && AMConfig.orcaSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ORCA.get(), AMConfig.orcaSpawnWeight, 3, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.sunbird, event.getCategory(), event.getName()) && AMConfig.sunbirdSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SUNBIRD.get(), AMConfig.sunbirdSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.gorilla, event.getCategory(), event.getName()) && AMConfig.gorillaSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GORILLA.get(), AMConfig.gorillaSpawnWeight, 7, 7));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.crimsonMosquito, event.getCategory(), event.getName()) && AMConfig.crimsonMosquitoSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CRIMSON_MOSQUITO.get(), AMConfig.crimsonMosquitoSpawnWeight, 4, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.rattlesnake, event.getCategory(), event.getName()) && AMConfig.rattlesnakeSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.RATTLESNAKE.get(), AMConfig.rattlesnakeSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.endergrade, event.getCategory(), event.getName()) && AMConfig.endergradeSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ENDERGRADE.get(), AMConfig.endergradeSpawnWeight, 2, 6));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.hammerheadShark, event.getCategory(), event.getName()) && AMConfig.hammerheadSharkSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.HAMMERHEAD_SHARK.get(), AMConfig.hammerheadSharkSpawnWeight, 2, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.lobster, event.getCategory(), event.getName()) && AMConfig.lobsterSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.LOBSTER.get(), AMConfig.lobsterSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.komodoDragon, event.getCategory(), event.getName()) && AMConfig.komodoDragonSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.KOMODO_DRAGON.get(), AMConfig.komodoDragonSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.capuchinMonkey, event.getCategory(), event.getName()) && AMConfig.capuchinMonkeySpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CAPUCHIN_MONKEY.get(), AMConfig.capuchinMonkeySpawnWeight, 9, 16));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.caveCentipede, event.getCategory(), event.getName()) && AMConfig.caveCentipedeSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CENTIPEDE_HEAD.get(), AMConfig.caveCentipedeSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.warpedToad, event.getCategory(), event.getName()) && AMConfig.warpedToadSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.WARPED_TOAD.get(), AMConfig.warpedToadSpawnWeight, 5, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.moose, event.getCategory(), event.getName()) && AMConfig.mooseSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MOOSE.get(), AMConfig.mooseSpawnWeight, 3, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.mimicube, event.getCategory(), event.getName()) && AMConfig.mimicubeSpawnWeight > 0 && !AMConfig.mimicubeSpawnInEndCity) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MIMICUBE.get(), AMConfig.mimicubeSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.raccoon, event.getCategory(), event.getName()) && AMConfig.raccoonSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.RACCOON.get(), AMConfig.raccoonSpawnWeight, 2, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.blobfish, event.getCategory(), event.getName()) && AMConfig.blobfishSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.BLOBFISH.get(), AMConfig.blobfishSpawnWeight, 2, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.seal, event.getCategory(), event.getName()) && AMConfig.sealSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SEAL.get(), AMConfig.sealSpawnWeight, 3, 8));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.cockroach, event.getCategory(), event.getName()) && AMConfig.cockroachSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.COCKROACH.get(), AMConfig.cockroachSpawnWeight, 5, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.shoebill, event.getCategory(), event.getName()) && AMConfig.shoebillSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SHOEBILL.get(), AMConfig.shoebillSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.elephant, event.getCategory(), event.getName()) && AMConfig.elephantSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ELEPHANT.get(), AMConfig.elephantSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.soulVulture, event.getCategory(), event.getName()) && AMConfig.soulVultureSpawnWeight > 0 && !AMConfig.soulVultureSpawnOnFossil) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SOUL_VULTURE.get(), AMConfig.soulVultureSpawnWeight, 2, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.snowLeopard, event.getCategory(), event.getName()) && AMConfig.snowLeopardSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SNOW_LEOPARD.get(), AMConfig.snowLeopardSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.spectre, event.getCategory(), event.getName()) && AMConfig.spectreSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SPECTRE.get(), AMConfig.spectreSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.crow, event.getCategory(), event.getName()) && AMConfig.crowSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CROW.get(), AMConfig.crowSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.alligatorSnappingTurtle, event.getCategory(), event.getName()) && AMConfig.alligatorSnappingTurtleSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ALLIGATOR_SNAPPING_TURTLE.get(), AMConfig.alligatorSnappingTurtleSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.mungus, event.getCategory(), event.getName()) && AMConfig.mungusSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MUNGUS.get(), AMConfig.mungusSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.mantisShrimp, event.getCategory(), event.getName()) && AMConfig.mantisShrimpSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MANTIS_SHRIMP.get(), AMConfig.mantisShrimpSpawnWeight, 1, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.guster, event.getCategory(), event.getName()) && AMConfig.gusterSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GUSTER.get(), AMConfig.gusterSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.warpedMosco, event.getCategory(), event.getName()) && AMConfig.warpedMoscoSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.WARPED_MOSCO.get(), AMConfig.warpedMoscoSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.straddler, event.getCategory(), event.getName()) && AMConfig.straddlerSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.STRADDLER.get(), AMConfig.straddlerSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.stradpole, event.getCategory(), event.getName()) && AMConfig.stradpoleSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.STRADPOLE.get(), AMConfig.stradpoleSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.emu, event.getCategory(), event.getName()) && AMConfig.emuSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.EMU.get(), AMConfig.emuSpawnWeight, 2, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.platypus, event.getCategory(), event.getName()) && AMConfig.platypusSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.PLATYPUS.get(), AMConfig.platypusSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.dropbear, event.getCategory(), event.getName()) && AMConfig.dropbearSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.DROPBEAR.get(), AMConfig.dropbearSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.tasmanianDevil, event.getCategory(), event.getName()) && AMConfig.tasmanianDevilSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TASMANIAN_DEVIL.get(), AMConfig.tasmanianDevilSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.kangaroo, event.getCategory(), event.getName()) && AMConfig.kangarooSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.KANGAROO.get(), AMConfig.kangarooSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.cachalot_whale_spawns, event.getCategory(), event.getName()) && AMConfig.cachalotWhaleSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CACHALOT_WHALE.get(), AMConfig.cachalotWhaleSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.enderiophage_spawns, event.getCategory(), event.getName()) && AMConfig.enderiophageSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ENDERIOPHAGE.get(), AMConfig.enderiophageSpawnWeight, 2, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.baldEagle, event.getCategory(), event.getName()) && AMConfig.baldEagleSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.BALD_EAGLE.get(), AMConfig.baldEagleSpawnWeight, 2, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.tiger, event.getCategory(), event.getName()) && AMConfig.tigerSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TIGER.get(), AMConfig.tigerSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.tarantula_hawk, event.getCategory(), event.getName()) && AMConfig.tarantulaHawkSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TARANTULA_HAWK.get(), AMConfig.tarantulaHawkSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.void_worm, event.getCategory(), event.getName()) && AMConfig.voidWormSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.VOID_WORM.get(), AMConfig.voidWormSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.frilled_shark, event.getCategory(), event.getName()) && AMConfig.frilledSharkSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.FRILLED_SHARK.get(), AMConfig.frilledSharkSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.mimic_octopus, event.getCategory(), event.getName()) && AMConfig.mimicOctopusSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MIMIC_OCTOPUS.get(), AMConfig.mimicOctopusSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.seagull, event.getCategory(), event.getName()) && AMConfig.seagullSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SEAGULL.get(), AMConfig.seagullSpawnWeight, 3, 6));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.froststalker, event.getCategory(), event.getName()) && AMConfig.froststalkerSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.FROSTSTALKER.get(), AMConfig.froststalkerSpawnWeight, 5, 7));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.tusklin, event.getCategory(), event.getName()) && AMConfig.tusklinSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TUSKLIN.get(), AMConfig.tusklinSpawnWeight, 3, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.laviathan, event.getCategory(), event.getName()) && AMConfig.laviathanSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.LAVIATHAN.get(), AMConfig.laviathanSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.cosmaw, event.getCategory(), event.getName()) && AMConfig.cosmawSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.COSMAW.get(), AMConfig.cosmawSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.toucan, event.getCategory(), event.getName()) && AMConfig.toucanSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TOUCAN.get(), AMConfig.toucanSpawnWeight, 5, 5));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.maned_wolf, event.getCategory(), event.getName()) && AMConfig.manedWolfSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.MANED_WOLF.get(), AMConfig.manedWolfSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.anaconda, event.getCategory(), event.getName()) && AMConfig.anacondaSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ANACONDA.get(), AMConfig.anacondaSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.anteater, event.getCategory(), event.getName()) && AMConfig.anteaterSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ANTEATER.get(), AMConfig.anteaterSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.rocky_roller, event.getCategory(), event.getName()) && AMConfig.rockyRollerSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.ROCKY_ROLLER.get(), AMConfig.rockyRollerSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.flutter, event.getCategory(), event.getName()) && AMConfig.flutterSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.FLUTTER.get(), AMConfig.flutterSpawnWeight, 2, 4));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.gelada_monkey, event.getCategory(), event.getName()) && AMConfig.geladaMonkeySpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GELADA_MONKEY.get(), AMConfig.geladaMonkeySpawnWeight, 9, 16));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.leafcutter_anthill_spawns, event.getCategory(), event.getName()) && AMConfig.leafcutterAnthillSpawnChance > 0.0) {
            GenerationSettingsManager.register((String)event.getName().toString(), (PlacedFeature)LEAFCUTTER_ANTHILL_PF);
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.jerboa, event.getCategory(), event.getName()) && AMConfig.jerboaSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.JERBOA.get(), AMConfig.jerboaSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.terrapin, event.getCategory(), event.getName()) && AMConfig.terrapinSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.TERRAPIN.get(), AMConfig.terrapinSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.comb_jelly, event.getCategory(), event.getName()) && AMConfig.combJellySpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.COMB_JELLY.get(), AMConfig.combJellySpawnWeight, 2, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.cosmic_cod, event.getCategory(), event.getName()) && AMConfig.cosmicCodSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.COSMIC_COD.get(), AMConfig.cosmicCodSpawnWeight, 9, 13));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.bunfungus, event.getCategory(), event.getName()) && AMConfig.bunfungusSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.BUNFUNGUS.get(), AMConfig.bunfungusSpawnWeight, 1, 1));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.bison, event.getCategory(), event.getName()) && AMConfig.bisonSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.BISON.get(), AMConfig.bisonSpawnWeight, 6, 10));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.giant_squid, event.getCategory(), event.getName()) && AMConfig.giantSquidSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.GIANT_SQUID.get(), AMConfig.giantSquidSpawnWeight, 1, 2));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.devils_hole_pupfish, event.getCategory(), event.getName()) && AMConfig.devilsHolePupfishSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.DEVILS_HOLE_PUPFISH.get(), AMConfig.devilsHolePupfishSpawnWeight, 5, 12));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.catfish, event.getCategory(), event.getName()) && AMConfig.catfishSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.CATFISH.get(), AMConfig.catfishSpawnWeight, 1, 3));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.flying_fish, event.getCategory(), event.getName()) && AMConfig.flyingFishSpawnWeight > 0) {
            event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.FLYING_FISH.get(), AMConfig.flyingFishSpawnWeight, 3, 6));
        }
        if (AMWorldRegistry.testBiome(BiomeConfig.skelewag, event.getCategory(), event.getName()) && AMConfig.skelewagSpawnWeight > 0 && !AMConfig.restrictSkelewagSpawns) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)AMEntityRegistry.SKELEWAG.get(), AMConfig.skelewagSpawnWeight, 2, 3));
        }
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> F registerFeature(String name, F eature) {
        eature.setRegistryName("alexsmobs:leafcutter_hill");
        return (F)((Feature)Registry.m_122961_((Registry)Registry.f_122839_, (String)name, eature));
    }

    public static boolean testBiome(Pair<String, SpawnBiomeData> entry, Biome.BiomeCategory category, ResourceLocation registryName) {
        boolean result = false;
        try {
            result = BiomeConfig.test(entry, category, registryName);
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("could not test biome config for " + (String)entry.getLeft() + ", defaulting to no spawns for mob");
            result = false;
        }
        return result;
    }

    public static boolean testBiome(Pair<String, SpawnBiomeData> entry, Biome biome) {
        return AMWorldRegistry.testBiome(entry, biome.m_47567_(), biome.getRegistryName());
    }

    static {
        initBiomes = false;
    }
}

