/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lolcroc.craftingautomat.BufferHandler;
import lolcroc.craftingautomat.CraftingAutomat;
import lolcroc.craftingautomat.CraftingAutomatBlock;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import lolcroc.craftingautomat.CraftingAutomatContainer;
import lolcroc.craftingautomat.CraftingInventoryWrapper;
import lolcroc.craftingautomat.MatrixHandler;
import lolcroc.craftingautomat.ResultHandler;
import lolcroc.craftingautomat.ReversedInvWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class CraftingAutomatBlockEntity
extends BlockEntity
implements MenuProvider,
RecipeHolder,
Clearable {
    protected Component customName;
    protected LockCode lock = LockCode.f_19102_;
    protected StackedContents itemHelper = new StackedContents();
    protected Optional<CraftingRecipe> recipeUsed = Optional.empty();
    protected int ticksActive;
    DataSlot ticksHolder = new DataSlot(){

        public int m_6501_() {
            return CraftingAutomatBlockEntity.this.ticksActive;
        }

        public void m_6422_(int value) {
            CraftingAutomatBlockEntity.this.ticksActive = value;
        }
    };
    private CraftingFlag craftingFlag = CraftingFlag.NONE;
    protected DataSlot craftingFlagHolder = new DataSlot(){

        public int m_6501_() {
            return CraftingAutomatBlockEntity.this.craftingFlag.getIndex();
        }

        public void m_6422_(int value) {
            CraftingAutomatBlockEntity.this.craftingFlag = CraftingFlag.fromIndex(value);
        }
    };
    private static final EmptyHandler EMPTYHANDLER = new EmptyHandler();
    protected LazyOptional<IItemHandlerModifiable> bufferHandler = LazyOptional.of(() -> new BufferHandler(this));
    protected LazyOptional<IItemHandlerModifiable> matrixHandler = LazyOptional.of(() -> new MatrixHandler(this));
    protected LazyOptional<IItemHandlerModifiable> resultHandler = LazyOptional.of(ResultHandler::new);
    protected LazyOptional<IItemHandlerModifiable> combinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER), (IItemHandlerModifiable)this.bufferHandler.orElse((Object)EMPTYHANDLER)}));
    protected LazyOptional<IItemHandler> reversedBufferHandler = LazyOptional.of(() -> new ReversedInvWrapper((IItemHandlerModifiable)this.bufferHandler.orElse((Object)EMPTYHANDLER)));
    protected LazyOptional<CraftingContainer> matrixWrapper = LazyOptional.of(() -> new CraftingInventoryWrapper((IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER)));
    private static final Component DEFAULT_NAME = new TranslatableComponent("container." + CraftingAutomatBlock.REGISTRY_NAME.toString());
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});

    public CraftingAutomatBlockEntity(BlockPos pos, BlockState state) {
        super(CraftingAutomat.BlockEntityTypes.autocrafter, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CraftingAutomatBlockEntity entity) {
        ++entity.ticksActive;
        if (entity.ticksActive <= (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get() && !entity.isReady() || entity.ticksActive >= (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get() + (Integer)CraftingAutomatConfig.COOLDOWN_TICKS.get()) {
            entity.ticksActive = 0;
            level.m_46597_(pos, (BlockState)entity.m_58900_().m_61124_((Property)CraftingAutomatBlock.ACTIVE, (Comparable)Boolean.FALSE));
        } else if (entity.ticksActive == (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get()) {
            entity.resultHandler.ifPresent(h -> {
                ItemStack stack = h.getStackInSlot(0).m_41777_();
                if (!stack.m_41619_()) {
                    ResultHandler.outputStack(entity, stack, false);
                }
            });
            entity.consumeIngredients(null);
        }
        entity.m_6596_();
    }

    public boolean isReady() {
        return this.craftingFlag == CraftingFlag.READY;
    }

    public void onLoad() {
        super.onLoad();
        this.updateRecipe();
    }

    public void updateRecipe() {
        if (this.m_58898_()) {
            this.matrixWrapper.ifPresent(w -> {
                this.recipeUsed = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)w, this.f_58857_).filter(r -> this.m_40135_(this.f_58857_, null, (Recipe<?>)r));
                this.resultHandler.ifPresent(h -> h.setStackInSlot(0, this.recipeUsed.map(r -> r.m_5874_((Container)w)).orElse(ItemStack.f_41583_)));
            });
            this.craftingFlag = CraftingFlag.getNewFlag(this.recipeUsed, this.itemHelper);
        }
    }

    public void m_6211_() {
        this.combinedHandler.ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                h.setStackInSlot(i, ItemStack.f_41583_);
            }
        });
        this.updateRecipe();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        this.recipeUsed = Optional.ofNullable((CraftingRecipe)recipe);
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return this.recipeUsed.orElse(null);
    }

    public boolean m_40135_(Level level, @Nullable ServerPlayer player, Recipe<?> recipe) {
        return !level.m_46469_().m_46207_(GameRules.f_46151_) || recipe.m_5598_();
    }

    public void updateHelper() {
        this.bufferHandler.ifPresent(h -> ((BufferHandler)((Object)h)).m_5809_(this.itemHelper));
        this.craftingFlag = CraftingFlag.getNewFlag(this.recipeUsed, this.itemHelper);
    }

    public int getRecipeCount() {
        return this.recipeUsed.map(r -> this.itemHelper.m_36493_((Recipe)r, null)).orElse(0);
    }

    @Nonnull
    public Component m_5446_() {
        return this.hasCustomName() ? this.customName : DEFAULT_NAME;
    }

    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        return BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lock, (Component)this.m_5446_()) ? new CraftingAutomatContainer(id, inventory, this) : null;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(@Nullable Component name) {
        this.customName = name;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!compound.m_128437_("Items", 10).isEmpty()) {
            NonNullList items = NonNullList.m_122780_((int)19, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)items);
            int i = 1;
            while (i < items.size()) {
                int finalI = i++;
                this.combinedHandler.ifPresent(h -> h.setStackInSlot(finalI - 1, (ItemStack)items.get(finalI)));
            }
        } else {
            this.bufferHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)compound.m_128469_("Buffer")));
            this.matrixHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)compound.m_128469_("Matrix")));
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        this.ticksActive = compound.m_128451_("TicksActive");
        this.lock = LockCode.m_19111_((CompoundTag)compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.bufferHandler.ifPresent(h -> compound.m_128365_("Buffer", ((INBTSerializable)h).serializeNBT()));
        this.matrixHandler.ifPresent(h -> compound.m_128365_("Matrix", ((INBTSerializable)h).serializeNBT()));
        if (this.hasCustomName()) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128405_("TicksActive", this.ticksActive);
        this.lock.m_19109_(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.combinedHandler.cast();
            }
            if (facing == this.m_58900_().m_61143_((Property)CraftingAutomatBlock.FACING)) {
                return this.resultHandler.cast();
            }
            if (facing == Direction.DOWN) {
                return this.reversedBufferHandler.cast();
            }
            return this.bufferHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void consumeIngredients(@Nullable Player player) {
        this.recipeUsed.ifPresent(recipe -> {
            boolean ready = this.isReady();
            NonNullList remainingStacks = this.matrixWrapper.map(arg_0 -> ((CraftingRecipe)recipe).m_7457_(arg_0)).orElse(NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_));
            if (ready) {
                this.reversedBufferHandler.ifPresent(h -> recipe.m_7527_().forEach(i -> {
                    for (int j = 0; j < h.getSlots(); ++j) {
                        if (!i.test(h.getStackInSlot(j))) continue;
                        h.extractItem(j, 1, false);
                        break;
                    }
                }));
            } else {
                this.matrixHandler.ifPresent(h -> {
                    for (int i = 0; i < h.getSlots(); ++i) {
                        h.extractItem(i, 1, false);
                    }
                });
            }
            IntStream.range(0, remainingStacks.size()).mapToObj(i -> {
                ItemStack stack = (ItemStack)remainingStacks.get(i);
                return ready ? stack : this.matrixHandler.map(h -> h.insertItem(i, stack, false)).orElse(stack);
            }).filter(stack -> !stack.m_41619_()).map(stack -> this.reversedBufferHandler.map(h -> ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)false)).orElse(stack)).filter(stack -> !stack.m_41619_()).forEach(stack -> {
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                } else {
                    ResultHandler.outputStack(this, stack, true);
                }
            });
        });
    }

    static enum CraftingFlag {
        NONE,
        READY,
        MISSING,
        INVALID;

        private final List<Component> displayTags;
        private static final CraftingFlag[] VALUES;

        private CraftingFlag() {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent(this.toString()).m_130940_(ChatFormatting.GRAY));
            this.displayTags = list;
        }

        public int getIndex() {
            return this.ordinal();
        }

        public List<Component> getDisplayTags() {
            return this.displayTags;
        }

        public static CraftingFlag fromIndex(int idx) {
            return VALUES[idx];
        }

        public static CraftingFlag getNewFlag(Optional<CraftingRecipe> recipe, StackedContents helper) {
            return recipe.map(r -> r.m_5598_() ? INVALID : (helper.m_36493_((Recipe)r, null) > 0 ? READY : MISSING)).orElse(NONE);
        }

        public String toString() {
            return "container." + CraftingAutomatBlock.REGISTRY_NAME + ".flag." + StringUtils.toLowerCase((String)this.name());
        }

        static {
            VALUES = CraftingFlag.values();
        }
    }
}

