/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lolcroc.craftingautomat.CraftingAutomatNetwork;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="craftingautomat", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CraftingAutomatConfig {
    public static final String TICK_SETTINGS = "tickSettings";
    public static final String NETWORK_SETTINGS = "networkSettings";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.IntValue CRAFTING_TICKS;
    public static final ForgeConfigSpec.IntValue COOLDOWN_TICKS;
    public static final ForgeConfigSpec.BooleanValue SYNC_TICK_SETTINGS;

    public static void syncTickSettings(boolean logicalServer) {
        if (logicalServer) {
            if (((Boolean)SYNC_TICK_SETTINGS.get()).booleanValue()) {
                CraftingAutomatNetwork.overrideClientConfigs(COOLDOWN_TICKS, CRAFTING_TICKS);
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.putAll(Stream.of(COOLDOWN_TICKS, CRAFTING_TICKS).collect(Collectors.toMap(ForgeConfigSpec.ConfigValue::getPath, ForgeConfigSpec.ConfigValue::get))));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CraftingAutomatConfig.syncTickSettings(!event.getEntity().f_19853_.f_46443_);
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        CraftingAutomatConfig.syncTickSettings(ServerLifecycleHooks.getCurrentServer() != null);
    }

    static {
        COMMON_BUILDER.comment("Tick settings (20 ticks = 1 second)").push(TICK_SETTINGS);
        CRAFTING_TICKS = COMMON_BUILDER.comment("Number of ticks to craft a recipe").defineInRange("craftingTicks", 8, 1, Integer.MAX_VALUE);
        COOLDOWN_TICKS = COMMON_BUILDER.comment("Number of ticks to cool down").defineInRange("cooldownTicks", 16, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Network settings").push(NETWORK_SETTINGS);
        SYNC_TICK_SETTINGS = COMMON_BUILDER.comment("Synchronize tick settings to players.\nDisabling this setting may cause visual glitches for other players in crafting progress.\nOther players may need to manually alter their tick settings to match the server host.").define("synchronizeTickSettings", true);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static final Map<List<String>, Integer> VALUES = new HashMap<List<String>, Integer>();

        public static Integer get(ForgeConfigSpec.IntValue cfgval) {
            return VALUES.getOrDefault(cfgval.getPath(), (Integer)cfgval.get());
        }

        public static void putAll(Map<List<String>, Integer> vals) {
            VALUES.putAll(vals);
        }
    }
}

