/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class CraftingAutomatNetwork {
    private static int messageID;
    private static final String PROTOCOL_VERSION = "1";
    private static final ResourceLocation REGISTRY_NAME;
    public static final SimpleChannel INSTANCE;

    public static int nextID() {
        return messageID++;
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(CraftingAutomatNetwork.nextID(), SOverrideConfigPacket.class, SOverrideConfigPacket::toBytes, SOverrideConfigPacket::new, SOverrideConfigPacket::handle);
    }

    public static void overrideClientConfigs(ForgeConfigSpec.IntValue ... vals) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SOverrideConfigPacket(vals));
    }

    static {
        REGISTRY_NAME = new ResourceLocation("craftingautomat", "network");
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)REGISTRY_NAME, () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    private static class SOverrideConfigPacket {
        private Map<List<String>, Integer> values = new HashMap<List<String>, Integer>();

        public SOverrideConfigPacket(FriendlyByteBuf buf) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int val = buf.readInt();
                int pathsize = buf.readInt();
                ArrayList path = Lists.newArrayList();
                for (int j = 0; j < pathsize; ++j) {
                    path.add(buf.m_130277_());
                }
                this.values.put(path, val);
            }
        }

        public SOverrideConfigPacket(ForgeConfigSpec.IntValue ... vals) {
            for (ForgeConfigSpec.IntValue val : vals) {
                this.values.put(val.getPath(), (Integer)val.get());
            }
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.values.size());
            for (Map.Entry<List<String>, Integer> e : this.values.entrySet()) {
                buf.writeInt(e.getValue().intValue());
                buf.writeInt(e.getKey().size());
                e.getKey().forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
            }
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> CraftingAutomatConfig.Client.putAll(this.values));
            ctx.get().setPacketHandled(true);
        }
    }
}

