/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Supplier;
import lolcroc.craftingautomat.CraftingAutomatBlockEntity;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import lolcroc.craftingautomat.CraftingAutomatContainer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CraftingAutomatScreen
extends AbstractContainerScreen<CraftingAutomatContainer> {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 197;
    private static final ResourceLocation TEXTURE = new ResourceLocation("craftingautomat", "textures/gui/container/crafting_automat.png");
    private static final Supplier<Integer> CRAFTING_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.CRAFTING_TICKS);
    private static final Supplier<Integer> COOLDOWN_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.COOLDOWN_TICKS);

    public CraftingAutomatScreen(CraftingAutomatContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 197;
        this.f_97728_ = 28;
    }

    private int getProgressWidth() {
        int ticks = ((CraftingAutomatContainer)this.f_97732_).getProgress();
        if (ticks <= 0) {
            return 0;
        }
        if (ticks > CRAFTING_TICKS.get()) {
            return (COOLDOWN_TICKS.get() + CRAFTING_TICKS.get() - ticks) * 24 / COOLDOWN_TICKS.get();
        }
        return ticks * 24 / CRAFTING_TICKS.get();
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(stack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(stack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int w = this.getProgressWidth();
        this.m_93228_(stack, i + 89, j + 34, 176, 0, w + 1, 16);
        CraftingAutomatBlockEntity.CraftingFlag flag = ((CraftingAutomatContainer)this.f_97732_).getCraftingFlag();
        if (flag != CraftingAutomatBlockEntity.CraftingFlag.NONE) {
            this.m_93228_(stack, i + 142, j + 26, 176 + 8 * (flag.getIndex() - 1), 17, 8, 8);
            if (this.m_6774_(142, 26, 8, 8, mouseX, mouseY)) {
                this.m_169388_(stack, flag.getDisplayTags(), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }
}

