/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.azalea.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SurfaceMossBlock
extends Block {
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)1, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)15.9, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.1);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.9, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1, (double)16.0);
    protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)15.9, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SurfaceMossBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76302_, (MaterialColor)MaterialColor.f_76363_).m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_154668_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.DOWN -> DOWN_AABB;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        return world.m_8055_(blockpos).m_60783_((BlockGetter)world, blockpos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)LAYERS) < 3 || super.m_6864_(state, context);
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)LAYERS) + 1)));
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState p_152033_, Rotation p_152034_) {
        return (BlockState)p_152033_.m_61124_((Property)FACING, (Comparable)p_152034_.m_55954_((Direction)p_152033_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_152030_, Mirror p_152031_) {
        return p_152030_.m_60717_(p_152031_.m_54846_((Direction)p_152030_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS, FACING});
    }

    public PushReaction m_5537_(BlockState p_152047_) {
        return PushReaction.DESTROY;
    }
}

