/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChunkLoaderUtil {
    public static Capability<ChunkTracker> TRACKER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkTracker>(){});

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent e) {
        e.register(ChunkTracker.class);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Level> e) {
        Level world = (Level)e.getObject();
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return;
        }
        final LazyOptional tracker = LazyOptional.of(() -> new ChunkTracker((ServerLevel)world));
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == TRACKER_CAPABILITY ? tracker.cast() : LazyOptional.empty();
            }

            public Tag serializeNBT() {
                return tracker.map(ChunkTracker::write).orElse(null);
            }

            public void deserializeNBT(Tag nbt) {
                tracker.ifPresent(chunkTracker -> chunkTracker.read(nbt));
            }
        });
        e.addListener(() -> ((LazyOptional)tracker).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || !(e.world instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)e.world;
        ServerChunkCache chunkProvider = world.m_7726_();
        int tickSpeed = world.m_46469_().m_46215_(GameRules.f_46143_);
        if (tickSpeed > 0) {
            world.getCapability(TRACKER_CAPABILITY).ifPresent(tracker -> {
                for (ChunkPos pos : tracker.chunks.keySet()) {
                    if (chunkProvider.f_8325_.m_183262_(pos, false).size() != 0) continue;
                    world.m_8714_(world.m_6325_(pos.f_45578_, pos.f_45579_), tickSpeed);
                }
            });
        }
    }

    public static class ChunkTracker {
        private final ServerLevel world;
        private final Map<ChunkPos, List<BlockPos>> chunks = new HashMap<ChunkPos, List<BlockPos>>();

        public ChunkTracker(ServerLevel world) {
            this.world = world;
        }

        public ChunkTracker() {
            this.world = null;
        }

        public void add(ChunkPos chunk, BlockPos loader) {
            if (this.chunks.containsKey(chunk) && this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (!this.chunks.containsKey(chunk)) {
                this.chunks.put(chunk, new LinkedList());
                this.world.m_8602_(chunk.f_45578_, chunk.f_45579_, true);
            }
            this.chunks.get(chunk).add(loader);
        }

        public void remove(ChunkPos chunk, BlockPos loader) {
            if (!this.chunks.containsKey(chunk) || !this.chunks.get(chunk).contains(loader)) {
                return;
            }
            if (this.chunks.get(chunk).size() == 1) {
                this.world.m_8602_(chunk.f_45578_, chunk.f_45579_, false);
                this.chunks.remove(chunk);
            } else {
                this.chunks.get(chunk).remove(loader);
            }
        }

        public CompoundTag write() {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry<ChunkPos, List<BlockPos>> entry : this.chunks.entrySet()) {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.m_128356_("chunk", entry.getKey().m_45588_());
                LongArrayTag blocks = new LongArrayTag(entry.getValue().stream().map(BlockPos::m_121878_).collect(Collectors.toList()));
                chunkTag.m_128365_("blocks", (Tag)blocks);
                compound.m_128365_(entry.getKey().f_45578_ + ";" + entry.getKey().f_45579_, (Tag)chunkTag);
            }
            return compound;
        }

        public void read(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                for (String key : compound.m_128431_()) {
                    CompoundTag chunkTag = compound.m_128469_(key);
                    ChunkPos chunk = new ChunkPos(chunkTag.m_128454_("chunk"));
                    LongArrayTag blocks = (LongArrayTag)chunkTag.m_128423_("blocks");
                    Arrays.stream(blocks.m_128851_()).mapToObj(BlockPos::m_122022_).forEach(pos -> this.add(chunk, (BlockPos)pos));
                }
            }
        }
    }
}

