/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.OptionalLong;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCoreConfig;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.event.ConfigEventHandler;
import team.creative.creativecore.common.config.gui.ClientSyncGuiLayer;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.gui.handler.GuiHandler;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.packet.ControlSyncPacket;
import team.creative.creativecore.common.gui.packet.LayerClosePacket;
import team.creative.creativecore.common.gui.packet.LayerOpenPacket;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.argument.StringArrayArgumentType;

@Mod(value="creativecore")
public class CreativeCore {
    public static final String MODID = "creativecore";
    public static final Logger LOGGER = LogManager.getLogger((String)"creativecore");
    public static final CreativeCoreConfig CONFIG = new CreativeCoreConfig();
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("creativecore", "main"));
    public static ConfigEventHandler CONFIG_HANDLER;
    public static final ResourceLocation FAKE_WORLD_LOCATION;
    public static DimensionType FAKE_DIMENSION;
    public static ResourceKey<Level> FAKE_DIMENSION_NAME;
    public static MenuType<ContainerIntegration> GUI_CONTAINER;

    public CreativeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(MenuType.class, this::registerMenus);
        MinecraftForge.EVENT_BUS.addListener(this::server);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(CreativeCoreClient::commands));
        GuiHandler.register("clientconfig", (player, nbt) -> new ClientSyncGuiLayer(CreativeConfigRegistry.ROOT));
        GuiHandler.register("config", (player, nbt) -> new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Dist.DEDICATED_SERVER));
        GUI_CONTAINER = new MenuType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }

            public ContainerIntegration create(int windowId, Inventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }
        };
        GUI_CONTAINER.setRegistryName("container");
    }

    public void registerMenus(RegistryEvent.Register<MenuType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MenuType[]{GUI_CONTAINER});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(CreativeCoreClient.class);
        CreativeCoreClient.init(event);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void server(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"cmdconfig").executes(x -> {
            GuiHandler.openGui("config", new CompoundTag(), (Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConfigurationChangePacket.class, ConfigurationChangePacket::new);
        NETWORK.registerType(ConfigurationClientPacket.class, ConfigurationClientPacket::new);
        NETWORK.registerType(ConfigurationPacket.class, ConfigurationPacket::new);
        NETWORK.registerType(LayerClosePacket.class, LayerClosePacket::new);
        NETWORK.registerType(LayerOpenPacket.class, LayerOpenPacket::new);
        NETWORK.registerType(OpenGuiPacket.class, OpenGuiPacket::new);
        NETWORK.registerType(ControlSyncPacket.class, ControlSyncPacket::new);
        CONFIG_HANDLER = new ConfigEventHandler(FMLPaths.CONFIGDIR.get().toFile(), LOGGER);
        MinecraftForge.EVENT_BUS.register(GuiEventHandler.class);
        FAKE_DIMENSION = DimensionType.m_188324_((OptionalLong)OptionalLong.empty(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (double)1.0, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (int)-64, (int)384, (int)384, (ResourceLocation)BlockTags.f_13058_.m_6979_(), (ResourceLocation)DimensionType.f_63840_, (float)0.0f);
        ArgumentTypes.m_121601_((String)"names", StringArrayArgumentType.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> StringArrayArgumentType.stringArray()));
        GuiHandler.register("item", (player, nbt) -> {
            InteractionHand hand = nbt.m_128471_("main_hand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() instanceof GuiHandler) {
                return ((GuiHandler)stack.m_41720_()).create(player, nbt);
            }
            return null;
        });
    }

    static {
        FAKE_WORLD_LOCATION = new ResourceLocation(MODID, "fake");
        FAKE_DIMENSION_NAME = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)FAKE_WORLD_LOCATION);
    }
}

