/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferBuilderUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Field bufferField = ObfuscationReflectionHelper.findField(BufferBuilder.class, (String)"f_85648_");
    public static final Field nextElementByteField = ObfuscationReflectionHelper.findField(BufferBuilder.class, (String)"f_85652_");
    public static final Field verticesField = ObfuscationReflectionHelper.findField(BufferBuilder.class, (String)"f_85654_");
    public static final Method ensureCapacity = ObfuscationReflectionHelper.findMethod(BufferBuilder.class, (String)"m_85722_", (Class[])new Class[]{Integer.TYPE});

    public static void ensureCapacity(BufferBuilder builder, int size) {
        try {
            ensureCapacity.invoke((Object)builder, size);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    public static void ensureTotalSize(BufferBuilder builder, int size) {
        int toAdd = size - BufferBuilderUtils.getBufferSizeByte(builder);
        if (size > 0) {
            BufferBuilderUtils.growBufferSmall(builder, toAdd);
        }
    }

    public static ByteBuffer getBuffer(BufferBuilder builder) {
        try {
            return (ByteBuffer)bufferField.get(builder);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getVertexCount(BufferBuilder builder) {
        try {
            return verticesField.getInt(builder);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static void growBufferSmall(BufferBuilder builder, int size) {
        try {
            ByteBuffer buffer = (ByteBuffer)bufferField.get(builder);
            if (nextElementByteField.getInt(builder) + size > buffer.capacity()) {
                LOGGER.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)buffer.capacity(), (Object)(buffer.capacity() + size));
                ByteBuffer bytebuffer = MemoryTracker.m_182529_((ByteBuffer)buffer, (int)(buffer.capacity() + size));
                bytebuffer.rewind();
                bufferField.set(builder, bytebuffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static int getBufferSizeInt(BufferBuilder builder) {
        return builder.getVertexFormat().m_86017_() * BufferBuilderUtils.getVertexCount(builder);
    }

    public static int getBufferSizeByte(BufferBuilder builder) {
        return builder.getVertexFormat().m_86020_() * BufferBuilderUtils.getVertexCount(builder);
    }
}

