/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControlHolder;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.premade.SoundConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.controls.GuiComboBox;
import team.creative.creativecore.common.gui.controls.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.GuiSlider;
import team.creative.creativecore.common.gui.controls.GuiStateButton;
import team.creative.creativecore.common.gui.controls.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.GuiTextfield;
import team.creative.creativecore.common.gui.controls.layout.GuiHBox;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Pair;
import team.creative.creativecore.common.util.type.PairList;

public abstract class ConfigTypeConveration<T> {
    private static HashMap<Class, ConfigTypeConveration> types = new HashMap();
    private static PairList<Predicate<Class>, ConfigTypeConveration> specialTypes = new PairList();
    private static final ICreativeConfigHolder fakeParent = new ICreativeConfigHolder(){

        @Override
        public ConfigSynchronization synchronization() {
            return ConfigSynchronization.UNIVERSAL;
        }

        @Override
        public JsonObject save(boolean saveDefault, boolean ignoreRestart, Dist side) {
            return null;
        }

        @Override
        public void restoreDefault(Dist side, boolean ignoreRestart) {
        }

        @Override
        public String[] path() {
            return new String[0];
        }

        @Override
        public ICreativeConfigHolder parent() {
            return null;
        }

        @Override
        public Collection<String> names() {
            return null;
        }

        @Override
        public void load(boolean loadDefault, boolean ignoreRestart, JsonObject json, Dist side) {
        }

        @Override
        public boolean isEmptyWithoutForce(Dist side) {
            return false;
        }

        @Override
        public boolean isEmpty(Dist side) {
            return false;
        }

        @Override
        public boolean isDefault(Dist side) {
            return false;
        }

        @Override
        public ConfigKey getField(String key) {
            return null;
        }

        @Override
        public Object get(String key) {
            return null;
        }

        @Override
        public Collection<? extends ConfigKey> fields() {
            return null;
        }
    };
    private static ConfigTypeConveration<ConfigHolderObject> holderConveration;

    public static <T, U extends T> ConfigTypeConveration<T> registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        types.put(clazz, type);
        return type;
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        specialTypes.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (types.containsKey(typeClass)) {
            return true;
        }
        if (typeClass.isAnnotationPresent(CreativeConfig.class)) {
            return false;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static ConfigTypeConveration getUnsafe(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        return null;
    }

    public static Object read(Class typeClass, Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).readElement(defaultValue, loadDefault, ignoreRestart, element, side, key);
    }

    public static JsonElement write(Class typeClass, Object value, Object defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).writeElement(value, defaultValue, saveDefault, ignoreRestart, side, key);
    }

    public abstract T createPrimitiveDefault(Class var1);

    public abstract T readElement(T var1, boolean var2, boolean var3, JsonElement var4, Dist var5, @Nullable ConfigKey.ConfigKeyField var6);

    public abstract JsonElement writeElement(T var1, T var2, boolean var3, boolean var4, Dist var5, @Nullable ConfigKey.ConfigKeyField var6);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void createControls(GuiParent var1, @Nullable ConfigKey.ConfigKeyField var2, Class var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void loadValue(T var1, GuiParent var2, @Nullable ConfigKey.ConfigKeyField var3);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T saveValue(GuiParent var1, Class var2, @Nullable ConfigKey.ConfigKeyField var3);

    public abstract T set(ConfigKey.ConfigKeyField var1, T var2);

    @OnlyIn(value=Dist.CLIENT)
    public T save(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
        T value = this.saveValue(parent, clazz, key);
        if (value != null && key != null) {
            return this.set(key, value);
        }
        return value;
    }

    public boolean areEqual(T one, T two) {
        return one.equals(two);
    }

    public static Object parseObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        if (ConfigTypeConveration.has(object.getClass())) {
            return object;
        }
        return new ConfigHolderObject(parent, synchronization, key, object);
    }

    static {
        SimpleConfigTypeConveration<Boolean> booleanType = new SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(Boolean defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, Boolean defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.add(new GuiStateButton("data", 0, 0, 0, ChatFormatting.RED + "false", ChatFormatting.GREEN + "true"));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Boolean value, GuiParent parent) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                button.setState(value != false ? 1 : 0);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Boolean saveValue(GuiParent parent, Class clazz) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                return button.getState() == 1;
            }

            @Override
            public Boolean set(ConfigKey.ConfigKeyField key, Boolean value) {
                return value;
            }

            @Override
            public Boolean createPrimitiveDefault(Class clazz) {
                return Boolean.FALSE;
            }
        };
        ConfigTypeConveration.registerType(Boolean.TYPE, booleanType);
        ConfigTypeConveration.registerType(Boolean.class, booleanType);
        SimpleConfigTypeConveration<Number> numberType = new SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(Number defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class<?> clazz = defaultValue.getClass();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, Number defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null && decRange.slider()) {
                            parent.add(new GuiSlider("data", 0, 0, recommendedWidth, 14, decRange.min(), decRange.min(), decRange.max()));
                            return;
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null && intRange.slider()) {
                            parent.add(new GuiSteppedSlider("data", 0, 0, recommendedWidth, 14, intRange.min(), intRange.min(), intRange.max()));
                            return;
                        }
                    }
                }
                GuiTextfield textfield = new GuiTextfield("data", 0, 0, recommendedWidth, 14);
                if (decimal) {
                    textfield.setFloatOnly();
                } else {
                    textfield.setNumbersIncludingNegativeOnly();
                }
                parent.add(textfield);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Number value, GuiParent parent) {
                GuiControl control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    button.setValue(value.intValue());
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    button.setValue(value.doubleValue());
                } else {
                    ((GuiTextfield)control).setText(value.toString());
                }
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            public Number parseNumber(Class clazz, String text) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    try {
                        return Float.valueOf(Float.parseFloat(text));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    try {
                        return Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        return 0.0;
                    }
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    try {
                        return Byte.parseByte(text);
                    }
                    catch (NumberFormatException e) {
                        return (byte)0;
                    }
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    try {
                        return Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        return (short)0;
                    }
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    try {
                        return Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    try {
                        return Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                return 0;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Number saveValue(GuiParent parent, Class clazz) {
                Object text;
                GuiControl control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    text = "" + (int)button.value;
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    text = "" + button.value;
                } else {
                    text = ((GuiTextfield)control).getText();
                }
                return this.parseNumber(clazz, (String)text);
            }

            @Override
            public Number set(ConfigKey.ConfigKeyField key, Number value) {
                Class clazz = key.getType();
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, Mth.m_14008_((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, Mth.m_14045_((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                    }
                }
                return value;
            }

            @Override
            public Number createPrimitiveDefault(Class clazz) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    return 0.0;
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)0;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)0;
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    return 0;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return 0L;
                }
                return 0;
            }
        };
        ConfigTypeConveration.registerType(Byte.TYPE, numberType);
        ConfigTypeConveration.registerType(Byte.class, numberType);
        ConfigTypeConveration.registerType(Short.TYPE, numberType);
        ConfigTypeConveration.registerType(Short.class, numberType);
        ConfigTypeConveration.registerType(Integer.TYPE, numberType);
        ConfigTypeConveration.registerType(Integer.class, numberType);
        ConfigTypeConveration.registerType(Long.TYPE, numberType);
        ConfigTypeConveration.registerType(Long.class, numberType);
        ConfigTypeConveration.registerType(Float.TYPE, numberType);
        ConfigTypeConveration.registerType(Float.class, numberType);
        ConfigTypeConveration.registerType(Double.TYPE, numberType);
        ConfigTypeConveration.registerType(Double.class, numberType);
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(String defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, String defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.add(new GuiTextfield("data", 0, 0, recommendedWidth, 14));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(String value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected String saveValue(GuiParent parent, Class clazz) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return button.getText();
            }

            @Override
            public String set(ConfigKey.ConfigKeyField key, String value) {
                return value;
            }

            @Override
            public String createPrimitiveDefault(Class clazz) {
                return "";
            }
        });
        ConfigTypeConveration.registerType(SoundConfig.class, new ConfigTypeConveration<SoundConfig>(){

            @Override
            public SoundConfig createPrimitiveDefault(Class clazz) {
                return new SoundConfig(new ResourceLocation("missing"));
            }

            @Override
            public SoundConfig readElement(SoundConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    return new SoundConfig(new ResourceLocation(element.getAsJsonObject().get("sound").getAsString()), element.getAsJsonObject().get("volume").getAsFloat(), element.getAsJsonObject().get("pitch").getAsFloat());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(SoundConfig value, SoundConfig defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, ConfigKey.ConfigKeyField key) {
                JsonObject json = new JsonObject();
                json.addProperty("sound", value.event.toString());
                json.addProperty("volume", (Number)Float.valueOf(value.volume));
                json.addProperty("pitch", (Number)Float.valueOf(value.pitch));
                return json;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                parent.add(new GuiTextfield("search", 0, 0, recommendedWidth, 14));
                parent.add(new GuiComboBoxMapped("sound", 0, 14, new TextMapBuilder<ResourceLocation>().addComponent(ForgeRegistries.SOUND_EVENTS.getKeys(), x -> new TextComponent(x.toString()))));
                GuiHBox hBox = new GuiHBox("vBox", 0, 30);
                hBox.add(new GuiLabel("volumeLabel", 0, 0).setTitle((Component)new TranslatableComponent("gui.volume")));
                hBox.add(new GuiSlider("volume", 0, 30, 40, 10, 1.0, 0.0, 1.0));
                hBox.add(new GuiLabel("pitchLabel", 0, 0).setTitle((Component)new TranslatableComponent("gui.pitch")));
                hBox.add(new GuiSlider("pitch", 30, 30, 40, 10, 1.0, 0.5, 2.0));
                parent.add(hBox);
                parent.setHeight(45);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(SoundConfig value, GuiParent parent, ConfigKey.ConfigKeyField key) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                box.select(value.event);
                volume.setValue(value.volume);
                pitch.setValue(value.pitch);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected SoundConfig saveValue(GuiParent parent, Class clazz, ConfigKey.ConfigKeyField key) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                return new SoundConfig((ResourceLocation)box.getSelected(), (float)volume.value, (float)pitch.value);
            }

            @Override
            public SoundConfig set(ConfigKey.ConfigKeyField key, SoundConfig value) {
                return value;
            }
        });
        holderConveration = ConfigTypeConveration.registerType(ConfigHolderObject.class, new ConfigTypeConveration<ConfigHolderObject>(){

            @Override
            public ConfigHolderObject readElement(ConfigHolderObject defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderObject value, ConfigHolderObject defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(ConfigHolderObject value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ConfigHolderObject saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderObject set(ConfigKey.ConfigKeyField key, ConfigHolderObject value) {
                return null;
            }

            @Override
            public ConfigHolderObject createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderDynamic.class, new ConfigTypeConveration<ConfigHolderDynamic>(){

            @Override
            public ConfigHolderDynamic readElement(ConfigHolderDynamic defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderDynamic value, ConfigHolderDynamic defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(ConfigHolderDynamic value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ConfigHolderDynamic saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderDynamic set(ConfigKey.ConfigKeyField key, ConfigHolderDynamic value) {
                return null;
            }

            @Override
            public ConfigHolderDynamic createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeConveration(){

            public Object readElement(Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    int size = Math.min(array.size(), Array.getLength(defaultValue));
                    Object object = Array.newInstance(defaultValue.getClass().getComponentType(), size);
                    for (int i = 0; i < size; ++i) {
                        Array.set(object, i, 8.read(defaultValue.getClass().getComponentType(), Array.get(defaultValue, i), loadDefault, ignoreRestart, array.get(i), side, null));
                    }
                    return object;
                }
                return defaultValue;
            }

            public JsonElement writeElement(Object value, Object defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                int length = Array.getLength(value);
                JsonArray array = new JsonArray();
                for (int i = 0; i < length; ++i) {
                    array.add(8.write(value.getClass().getComponentType(), Array.get(value, i), Array.get(defaultValue, i), saveDefault, ignoreRestart, side, null));
                }
                return array;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                parent.setHeight(160);
                GuiListBoxBase listBox = new GuiListBoxBase("data", 0, 0, parent.getWidth() - 10, 150, false, new ArrayList());
                parent.add(listBox);
            }

            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Object value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                if (!box.isEmpty()) {
                    box.clear();
                }
                Class<?> clazz = value.getClass().getComponentType();
                ConfigTypeConveration converation = 8.get(clazz);
                int length = Array.getLength(value);
                ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(length);
                for (int i = 0; i < length; ++i) {
                    Object entry = Array.get(value, i);
                    GuiConfigSubControl control = new GuiConfigSubControl("" + i, 2, 0, parent.getWidth(), 14);
                    converation.createControls(control, null, clazz, Math.min(100, control.getWidth()));
                    converation.loadValue(entry, control, null);
                    controls.add(control);
                }
                box.addAllItems(controls);
            }

            @OnlyIn(value=Dist.CLIENT)
            protected Object saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                Class<?> subClass = clazz.getComponentType();
                ConfigTypeConveration converation = 8.get(subClass);
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                Object value = Array.newInstance(subClass, box.size());
                for (int i = 0; i < box.size(); ++i) {
                    Array.set(value, i, converation.save((GuiParent)box.get(i), subClass, null));
                }
                return value;
            }

            public Object set(ConfigKey.ConfigKeyField key, Object value) {
                return value;
            }

            public boolean areEqual(Object one, Object two) {
                int lengthTwo;
                int lengthOne = Array.getLength(one);
                if (lengthOne != (lengthTwo = Array.getLength(two))) {
                    return false;
                }
                for (int i = 0; i < lengthOne; ++i) {
                    Object entryOne = Array.get(one, i);
                    Object entryTwo = Array.get(two, i);
                    if (entryOne.getClass().isArray()) {
                        if (!entryTwo.getClass().isArray()) {
                            return false;
                        }
                        if (!this.areEqual(entryOne, entryTwo)) {
                            return false;
                        }
                    }
                    if (entryOne.equals(entryTwo)) continue;
                    return false;
                }
                return true;
            }

            public Object createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> x.isEnum(), new SimpleConfigTypeConveration<Enum>(){

            @Override
            public Enum readElement(Enum defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, Enum defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.name());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.add(new GuiComboBox("data", 0, 0, new TextListBuilder().add(clazz.getEnumConstants(), x -> ((Enum)x).name())));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Enum value, GuiParent parent) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.ordinal());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Enum saveValue(GuiParent parent, Class clazz) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                return (Enum)clazz.getEnumConstants()[box.getIndex()];
            }

            @Override
            public Enum set(ConfigKey.ConfigKeyField key, Enum value) {
                return value;
            }

            @Override
            public Enum createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> List.class.isAssignableFrom((Class<?>)x) || x == ArrayList.class, new ConfigTypeConveration<List>(){

            private ConfigHolderObject constructHolder(Dist side, Object value) {
                return new ConfigHolderObject(fakeParent, side.isClient() ? ConfigSynchronization.CLIENT : ConfigSynchronization.SERVER, "", value);
            }

            private Object constructEmpty(Class clazz) {
                try {
                    Constructor con = clazz.getConstructor(new Class[0]);
                    return con.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public List readElement(List defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    Class clazz = this.getListType(key);
                    ArrayList<Object> list = new ArrayList<Object>(array.size());
                    ConfigTypeConveration conversation = 10.getUnsafe(clazz);
                    for (int i = 0; i < array.size(); ++i) {
                        if (conversation != null) {
                            list.add(conversation.readElement(conversation.createPrimitiveDefault(clazz), loadDefault, ignoreRestart, array.get(i), side, null));
                            continue;
                        }
                        Object value = this.constructEmpty(clazz);
                        holderConveration.readElement(this.constructHolder(side, value), loadDefault, ignoreRestart, array.get(i), side, null);
                        list.add(value);
                    }
                    return list;
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(List value, List defaultValue, boolean saveDefault, boolean ignoreRestart, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                JsonArray array = new JsonArray();
                Class clazz = this.getListType(key);
                ConfigTypeConveration conversation = 10.getUnsafe(clazz);
                for (int i = 0; i < value.size(); ++i) {
                    if (conversation != null) {
                        array.add(conversation.writeElement(value.get(i), null, saveDefault, ignoreRestart, side, key));
                        continue;
                    }
                    array.add(holderConveration.writeElement(this.constructHolder(side, value.get(i)), null, saveDefault, ignoreRestart, side, key));
                }
                return array;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
                parent.setHeight(160);
                GuiListBoxBase listBox = new GuiListBoxBase("data", 0, 0, parent.getWidth() - 10, 130, true, new ArrayList());
                parent.add(listBox);
                Class subClass = this.getListType(key);
                ConfigTypeConveration converation = 10.getUnsafe(subClass);
                int parentWidth = parent.getWidth() - 10;
                parent.add(new GuiButton("add", 0, 140, x -> {
                    GuiConfigSubControl control;
                    if (converation != null) {
                        control = new GuiConfigSubControl("0", 2, 0, parentWidth, 14);
                        converation.createControls(control, null, subClass, control.getWidth() - 35);
                    } else {
                        Object value = this.constructEmpty(subClass);
                        ConfigHolderObject holder = this.constructHolder(Dist.DEDICATED_SERVER, value);
                        control = new GuiConfigSubControlHolder("0", 2, 0, parentWidth, 14, (ICreativeConfigHolder)holder, value);
                        ((GuiConfigSubControlHolder)control).createControls();
                    }
                    listBox.addItem(control);
                }).setTitle((Component)new TranslatableComponent("gui.add")));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(List value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                if (!box.isEmpty()) {
                    box.clearItems();
                }
                Class clazz = this.getListType(key);
                ConfigTypeConveration converation = 10.getUnsafe(clazz);
                int parentWidth = parent.getWidth() - 10;
                ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(value.size());
                for (int i = 0; i < value.size(); ++i) {
                    GuiConfigSubControl control;
                    Object entry = value.get(i);
                    if (converation != null) {
                        control = new GuiConfigSubControl("" + i, 2, 0, parentWidth, 14);
                        converation.createControls(control, null, clazz, control.getWidth() - 35);
                        converation.loadValue(entry, control, null);
                    } else {
                        control = new GuiConfigSubControlHolder("0", 2, 0, parentWidth, 14, (ICreativeConfigHolder)this.constructHolder(Dist.DEDICATED_SERVER, entry), entry);
                        ((GuiConfigSubControlHolder)control).createControls();
                    }
                    controls.add(control);
                }
                box.addAllItems(controls);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected List saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                Class subClass = this.getListType(key);
                ConfigTypeConveration converation = 10.getUnsafe(subClass);
                GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
                ArrayList<Object> value = new ArrayList<Object>(box.size());
                for (int i = 0; i < box.size(); ++i) {
                    if (converation != null) {
                        value.add(converation.save((GuiParent)box.get(i), subClass, null));
                        continue;
                    }
                    ((GuiConfigSubControlHolder)box.get(i)).save();
                    value.add(((GuiConfigSubControlHolder)box.get((int)i)).value);
                }
                return value;
            }

            @Override
            public List set(ConfigKey.ConfigKeyField key, List value) {
                return value;
            }

            public Class getListType(ConfigKey.ConfigKeyField key) {
                ParameterizedType type = (ParameterizedType)key.field.getGenericType();
                return (Class)type.getActualTypeArguments()[0];
            }

            @Override
            public List createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(T defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.readElement(defaultValue, loadDefault, element);
        }

        public abstract T readElement(T var1, boolean var2, JsonElement var3);

        @Override
        public JsonElement writeElement(T value, T defaultValue, boolean ignoreRestart, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.writeElement(value, defaultValue, saveDefault);
        }

        public abstract JsonElement writeElement(T var1, T var2, boolean var3);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, @Nullable ConfigKey.ConfigKeyField key, Class clazz, int recommendedWidth) {
            this.createControls(parent, clazz, recommendedWidth);
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract void createControls(GuiParent var1, Class var2, int var3);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void loadValue(T value, GuiParent parent, @Nullable ConfigKey.ConfigKeyField key) {
            this.loadValue(value, parent);
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract void loadValue(T var1, GuiParent var2);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected T saveValue(GuiParent parent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
            return this.saveValue(parent, clazz);
        }

        @OnlyIn(value=Dist.CLIENT)
        protected abstract T saveValue(GuiParent var1, Class var2);
    }
}

