/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiConfigControl
extends GuiRow {
    public final ConfigKey.ConfigKeyField field;
    public final Dist side;
    private GuiButton resetButton;
    private final GuiColumn main;

    public GuiConfigControl(ConfigGuiLayer layer, ConfigKey.ConfigKeyField field, Dist side, String caption, String comment) {
        this.field = field;
        this.side = side;
        this.setExpandableX();
        GuiColumn text = new GuiColumn(100);
        text.valign = VAlign.CENTER;
        this.addColumn(text);
        text.add(new GuiLabel(caption + ":").setTitle((Component)new TextComponent(caption + ":")).setTooltip(new TextBuilder().translateIfCan(comment).build()));
        this.main = (GuiColumn)new GuiColumn(200).setExpandableX();
        this.addColumn(this.main);
        GuiColumn end = new GuiColumn(20);
        end.align = Align.CENTER;
        this.addColumn(end);
        this.resetButton = (GuiButton)new GuiButton("r", x -> {
            this.reset();
            if (layer != null) {
                layer.changed = true;
            }
        }).setTitle((Component)new TextComponent("r")).setAlign(Align.CENTER);
        end.add(this.resetButton.setTooltip(new TextBuilder().text("reset to default").build()));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void updateButton() {
        this.resetButton.enabled = !this.field.isDefault(this.field.converation.save(this.main, this.field.getType(), this.field), this.side);
    }

    public void init(JsonElement initalValue) {
        this.field.converation.createControls(this.main, this.field, this.field.getType());
        this.field.converation.loadValue(initalValue != null ? this.field.converation.readElement(this.field.getDefault(), false, false, initalValue, this.side, this.field) : this.field.get(), this.main, this.field);
        this.updateButton();
    }

    public void reset() {
        this.field.converation.loadValue(this.field.getDefault(), this.main, this.field);
        this.updateButton();
    }

    public void changed() {
        this.updateButton();
    }

    public JsonElement save() {
        Object value = this.field.converation.save(this.main, this.field.getType(), this.field);
        if (!this.field.get().equals(value)) {
            return this.field.converation.writeElement(value, this.field.getDefault(), true, false, this.side, this.field);
        }
        return null;
    }
}

