/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiLabel
extends GuiControl {
    protected CompiledText text;
    public Align align;

    public GuiLabel(String name, int x, int y) {
        super(name, x, y, 1, 10);
        if (this.text == null) {
            this.text = CompiledText.createAnySize();
        }
    }

    protected void updateDimension() {
        if (this.getParent() != null) {
            this.setWidth(this.getPreferredWidth());
            this.setHeight(this.getPreferredHeight());
        }
    }

    public GuiLabel setTitle(Component component) {
        this.text.setText(component);
        if (this.getParent() != null) {
            this.initiateLayoutUpdate();
        }
        return this;
    }

    public GuiLabel setTitle(List<Component> components) {
        this.text.setText(components);
        if (this.getParent() != null) {
            this.initiateLayoutUpdate();
        }
        return this;
    }

    @Override
    public void init() {
        this.updateDimension();
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, Rect rect, int mouseX, int mouseY) {
        this.text.render(matrix);
    }

    public void setWidthLayout(int width) {
        int offset = this.getContentOffset();
        this.text.setDimension(width - offset * 2, Integer.MAX_VALUE);
        this.text.calculateDimensions();
        this.setWidth(this.text.usedWidth + offset * 2);
        this.setHeight(this.text.usedHeight + offset * 2);
    }

    @Override
    public int getMinWidth() {
        return 10;
    }

    @Override
    public int getPreferredWidth() {
        return this.text.getTotalWidth() + this.getContentOffset() * 2;
    }

    public void setHeightLayout(int height) {
        this.text.setMaxHeight(height - this.getContentOffset() * 2);
        this.setHeight(height);
    }

    @Override
    public int getMinHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 + this.getContentOffset() * 2;
    }

    @Override
    public int getPreferredHeight() {
        return this.text.getTotalHeight() + this.getContentOffset() * 2;
    }
}

