/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.controls.GuiControlBasic;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiProgressbar
extends GuiControlBasic {
    public double pos;
    public double max;
    public boolean showToolTip = true;

    public GuiProgressbar(String name, int x, int y, int width, int height, double pos, double max) {
        super(name, x, y, width, height);
        this.pos = pos;
        this.max = max;
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public List<Component> getTooltip() {
        if (this.showToolTip) {
            return new TextBuilder().number(this.pos, true).text("/").number(this.max, true).text(" (").number(this.pos / this.max * 100.0, true).text("%)").build();
        }
        return super.getTooltip();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, Rect rect, int mouseX, int mouseY) {
        GuiStyle style = this.getStyle();
        double percent = this.pos / this.max;
        style.clickable.render(matrix, 0.0, 0.0, (int)(rect.getWidth() * percent), rect.getHeight());
        GuiRenderHelper.drawStringCentered(matrix, (int)Math.round(percent * 100.0) + "%", (float)rect.getWidth(), (float)rect.getHeight(), style.fontColor.toInt(), true);
    }
}

