/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiScrollBox
extends GuiParent {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public float scaleFactor;
    public boolean dragged;
    public int scrollbarWidth = 3;
    protected int initalWidth;
    protected int initalHeight;

    public GuiScrollBox(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, 1.0f);
    }

    public GuiScrollBox(String name, int x, int y, int width, int height, float scaleFactor) {
        super(name, x, y, width, height);
        this.scaleFactor = scaleFactor;
        this.initalWidth = width;
        this.initalHeight = height;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public double getOffsetY() {
        return -this.scrolled.current();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    public boolean mouseScrolled(double x, double y, double scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scrolled.set(this.scrolled.aimed() - scrolled * 10.0);
        this.onScrolled();
        return true;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0 && (double)this.getWidth() - x <= (double)this.scrollbarWidth && this.needsScrollbar()) {
            GuiScrollBox.playSound(SoundEvents.f_12490_);
            this.dragged = true;
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public void mouseMoved(double x, double y) {
        if (this.dragged) {
            GuiStyle style = this.getStyle();
            ControlFormatting formatting = this.getControlFormatting();
            int completeHeight = this.getHeight() - style.getBorder(formatting.border) * 2;
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.lastRenderedHeight * (float)completeHeight)));
            if (this.lastRenderedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            double percent = y / (double)(completeHeight - scrollThingHeight);
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMoved(x, y);
    }

    public void mouseReleased(double x, double y, int button) {
        super.mouseReleased(x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar() {
        return this.lastRenderedHeight > this.getHeight() - this.getContentOffset() * 2;
    }

    protected void renderContent(PoseStack matrix, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        super.renderContent(matrix, formatting, borderWidth, controlRect, realRect, mouseX, mouseY);
        realRect.scissor();
        GuiStyle style = this.getStyle();
        this.scrolled.tick();
        int completeHeight = this.getHeight() - style.getBorder(formatting.border) * 2;
        int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.lastRenderedHeight * (float)completeHeight)));
        if (this.lastRenderedHeight < completeHeight) {
            scrollThingHeight = completeHeight;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(matrix, controlRect.getWidth() + (double)(formatting.padding * 2) - (double)this.scrollbarWidth + (double)borderWidth, (int)(percent * (double)(completeHeight - scrollThingHeight)) + borderWidth, this.scrollbarWidth, scrollThingHeight);
        this.maxScroll = Math.max(0, this.lastRenderedHeight - completeHeight + formatting.padding * 2 + 1);
    }

    public void setWidthLayout(int width) {
        this.setWidth(width);
    }

    @Override
    public int getMinWidth() {
        return 20;
    }

    @Override
    public int getPreferredWidth() {
        return this.initalWidth;
    }

    public void setHeightLayout(int height) {
        this.setHeight(height);
    }

    @Override
    public int getMinHeight() {
        return 10;
    }

    @Override
    public int getPreferredHeight() {
        return this.initalHeight;
    }
}

