/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiScrollBox;
import team.creative.creativecore.common.gui.controls.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.GuiTextfield;
import team.creative.creativecore.common.gui.controls.SlotViewer;
import team.creative.creativecore.common.util.type.HashMapList;

public class GuiStackSelectorExtension
extends GuiScrollBox {
    public GuiStackSelector comboBox;
    public String search = "";

    public GuiStackSelectorExtension(String name, Player player, int x, int y, int width, int height, GuiStackSelector comboBox) {
        super(name, x, y, width, height);
        this.comboBox = comboBox;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.registerEventClick(event -> {
            if (event.control instanceof SlotViewer && event.control.getParent() == this) {
                comboBox.setSelected(((SlotViewer)event.control).stack);
                GuiStackSelectorExtension.playSound(SoundEvents.f_12490_);
                comboBox.closeBox();
            }
        });
        this.reloadControls();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        super.mouseClicked(x, y, button);
        return true;
    }

    @Override
    public void looseFocus() {
        this.comboBox.closeBox();
    }

    public boolean canOverlap() {
        return true;
    }

    public void reloadControls() {
        HashMapList<String, ItemStack> stacks;
        if (this.comboBox == null) {
            return;
        }
        HashMapList<String, ItemStack> hashMapList = stacks = this.search == null || this.search.equals("") ? this.comboBox.getStacks() : new HashMapList<String, ItemStack>();
        if (this.search != null && !this.search.equals("")) {
            for (Map.Entry<String, ArrayList<ItemStack>> entry : this.comboBox.getStacks().entrySet()) {
                for (ItemStack stack : entry.getValue()) {
                    if (!GuiStackSelector.contains(this.search, stack)) continue;
                    stacks.add(entry.getKey(), stack);
                }
            }
        }
        int height = 0;
        GuiTextfield textfield = null;
        if (this.comboBox.searchBar) {
            textfield = (GuiTextfield)this.get("searchBar");
        }
        this.clear();
        if (this.comboBox.searchBar) {
            height += 4;
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search, 3, height, this.getWidth() - 20, 14);
            }
            this.add(textfield);
            height += textfield.getHeight() + 4;
            textfield.focus();
        }
        for (Map.Entry entry : stacks.entrySet()) {
            GuiLabel label = new GuiLabel("title", 4, height).setTitle((Component)new TranslatableComponent((String)entry.getKey()));
            this.add(label);
            height += 12;
            int SlotsPerRow = (this.getWidth() - 10) / 17;
            int i = 0;
            for (ItemStack stack : entry.getValue()) {
                int row = i / SlotsPerRow;
                this.add(new SlotViewer("" + i, 3 + (i - row * SlotsPerRow) * 17, height + row * 17, stack){

                    public boolean mouseClicked(double x, double y, int button) {
                        return true;
                    }
                });
                ++i;
            }
            height = (int)((double)height + Math.ceil((double)i / (double)SlotsPerRow) * 17.0);
        }
        if (this.getParent() != null) {
            this.init();
        }
    }
}

