/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextListBuilder;

public class GuiStateButton
extends GuiButton {
    private int index = 0;
    public CompiledText[] states;
    public boolean autosize;

    public GuiStateButton(String name, int x, int y, int index, TextListBuilder states) {
        super(name, x, y, null);
        this.pressed = button -> {
            if (button == 1) {
                this.previousState();
            } else {
                this.nextState();
            }
        };
        this.index = index;
        this.autosize = true;
        this.buildStates(states);
    }

    public GuiStateButton(String name, int x, int y, int index, String ... states) {
        this(name, x, y, index, new TextListBuilder().add(states));
    }

    protected void buildStates(TextListBuilder builder) {
        this.states = new CompiledText[builder.size()];
        for (int i = 0; i < builder.size(); ++i) {
            this.states[i] = CompiledText.createAnySize();
            this.states[i].setText(builder.get(i));
        }
        if (this.index >= this.states.length) {
            this.index = 0;
        }
    }

    @Override
    public void setWidthLayout(int width) {
        int contentOffset = this.getContentOffset() * 2;
        int height = 0;
        for (CompiledText text : this.states) {
            text.setDimension(width, Integer.MAX_VALUE);
            height = Math.max(height, text.getTotalHeight() + contentOffset);
        }
        this.setWidth(width);
    }

    @Override
    public void setHeightLayout(int height) {
        for (CompiledText text : this.states) {
            text.setMaxHeight(height);
        }
        this.setHeight(height);
    }

    @Override
    public int getPreferredWidth() {
        int contentOffset = this.getContentOffset() * 2;
        int width = 0;
        for (CompiledText text : this.states) {
            width = Math.max(width, text.getTotalWidth() + contentOffset);
        }
        return width;
    }

    @Override
    public int getPreferredHeight() {
        int contentOffset = this.getContentOffset() * 2;
        int height = 0;
        for (CompiledText text : this.states) {
            height = Math.max(height, text.getTotalHeight() + contentOffset);
        }
        return height;
    }

    public void setState(int index) {
        this.index = index;
    }

    public int getState() {
        return this.index;
    }

    public void previousState() {
        int state = this.getState();
        if (--state < 0) {
            state = this.states.length - 1;
        }
        if (state >= this.states.length) {
            state = 0;
        }
        this.setState(state);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public void nextState() {
        int state = this.getState();
        if (++state < 0) {
            state = this.states.length - 1;
        }
        if (state >= this.states.length) {
            state = 0;
        }
        this.setState(state);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, Rect rect, int mouseX, int mouseY) {
        CompiledText text = this.states[this.index];
        matrix.m_85837_(rect.getWidth() / 2.0 - (double)(text.usedWidth / 2), rect.getHeight() / 2.0 - (double)(text.usedHeight / 2), 0.0);
        text.render(matrix);
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }
}

