/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.ITextCollection;

public class GuiComboBox
extends GuiLabel {
    protected GuiComboBoxExtension extension;
    public CompiledText[] lines;
    private int index;
    public boolean extensionLostFocus;

    public GuiComboBox(String name, ITextCollection builder) {
        super(name);
        this.lines = builder.build();
        if (this.index >= this.lines.length) {
            this.index = 0;
        }
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].alignment = Align.CENTER;
        }
        this.updateDisplay();
    }

    @Override
    public void tick() {
    }

    @Override
    public void closed() {
    }

    protected void updateDisplay() {
        this.text = this.lines[this.index];
    }

    @Override
    public void flowX(int width, int preferred) {
        for (CompiledText text : this.lines) {
            text.setDimension(width, Integer.MAX_VALUE);
        }
    }

    @Override
    public void flowY(int height, int preferred) {
        for (CompiledText text : this.lines) {
            text.setMaxHeight(height);
        }
    }

    @Override
    public int preferredWidth() {
        int contentOffset = this.getContentOffset() * 2;
        int width = 0;
        for (CompiledText text : this.lines) {
            width = Math.max(width, text.getTotalWidth() + contentOffset);
        }
        return width;
    }

    @Override
    public int preferredHeight() {
        int contentOffset = this.getContentOffset() * 2;
        int height = 0;
        for (CompiledText text : this.lines) {
            height = Math.max(height, text.getTotalHeight() + contentOffset);
        }
        return height;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean select(int index) {
        if (index >= 0 && index < this.lines.length) {
            this.index = index;
            this.updateDisplay();
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.extension == null) {
            this.openBox(rect);
        } else {
            this.closeBox();
        }
        GuiComboBox.playSound(SoundEvents.f_12490_);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    public void openBox(Rect rect) {
        this.extension = this.createBox();
        GuiLayer layer = this.getLayer();
        GuiChildControl child = layer.addHover(this.extension);
        this.extension.init();
        child.setX((int)rect.minX);
        child.setY((int)rect.maxY);
        child.setWidth((int)rect.getWidth());
        child.flowX();
        child.setHeight(child.getPreferredHeight());
        child.flowY();
        if (child.getY() + child.getHeight() > layer.getHeight() && rect.minY >= (double)child.getHeight()) {
            child.setY(child.getY() - (int)rect.getHeight() + child.getHeight());
        }
    }

    protected GuiComboBoxExtension createBox() {
        return new GuiComboBoxExtension(this.name + "extension", this);
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }

    @Override
    public void looseFocus() {
        if (this.extensionLostFocus && this.extension != null) {
            this.closeBox();
        }
    }
}

