/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.parent;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiScrollY
extends GuiParent {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public double scaleFactor;
    public boolean dragged;
    public int scrollbarWidth = 3;
    protected int cachedHeight;

    public GuiScrollY() {
        this("");
    }

    public GuiScrollY(String name) {
        super(name, GuiFlow.STACK_Y);
        this.scaleFactor = 1.0;
    }

    public GuiScrollY(String name, int width, int height) {
        this(name, width, height, 1.0f);
    }

    public GuiScrollY(String name, int width, int height, float scaleFactor) {
        super(name, (GuiFlow)GuiFlow.STACK_Y, width, height);
        this.scaleFactor = scaleFactor;
    }

    @Override
    public GuiScrollY setExpandable() {
        return (GuiScrollY)super.setExpandable();
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public double getOffsetY() {
        return -this.scrolled.current();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double scrolled) {
        if (super.mouseScrolled(rect, x, y, scrolled)) {
            return true;
        }
        this.scrolled.set(this.scrolled.aimed() - scrolled * 10.0);
        this.onScrolled();
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0 && rect.getWidth() - x <= (double)this.scrollbarWidth && this.needsScrollbar(rect)) {
            GuiScrollY.playSound(SoundEvents.f_12490_);
            this.dragged = true;
            return true;
        }
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.dragged) {
            GuiStyle style = this.getStyle();
            ControlFormatting formatting = this.getControlFormatting();
            int completeHeight = (int)(rect.getHeight() - (double)(style.getBorder(formatting.border) * 2));
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            double percent = y / (double)(completeHeight - scrollThingHeight);
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMoved(rect, x, y);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar(Rect rect) {
        return (double)this.cachedHeight > rect.getHeight() - (double)(this.getContentOffset() * 2);
    }

    @Override
    protected void renderContent(PoseStack matrix, GuiChildControl control, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        super.renderContent(matrix, control, formatting, borderWidth, controlRect, realRect, mouseX, mouseY);
        realRect.scissor();
        GuiStyle style = this.getStyle();
        this.scrolled.tick();
        int completeHeight = control.getHeight() - style.getBorder(formatting.border) * 2;
        int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
        if (this.cachedHeight < completeHeight) {
            scrollThingHeight = completeHeight;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(matrix, controlRect.getWidth() + (double)(formatting.padding * 2) - (double)this.scrollbarWidth + (double)borderWidth, (int)(percent * (double)(completeHeight - scrollThingHeight)) + borderWidth, this.scrollbarWidth, scrollThingHeight);
        this.maxScroll = Math.max(0, this.cachedHeight - completeHeight + formatting.padding * 2 + 1);
    }

    @Override
    public int getMinWidth() {
        return 10;
    }

    @Override
    public int getMinHeight() {
        return 10;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width - this.scrollbarWidth, preferred);
    }

    @Override
    public void flowY(int height, int preferred) {
        int y = 0;
        for (GuiChildControl child : this.controls) {
            child.setHeight(child.getPreferredHeight());
            child.setY(y);
            child.flowY();
            y += child.getHeight() + this.spacing;
        }
        this.cachedHeight = y;
    }
}

