/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.function.Consumer;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiButtonHold
extends GuiButton {
    public static final int initialWait = 250;
    public static final int continousWait = 100;
    public int clicked = -1;
    public boolean inital = false;
    public long wait = 0L;

    public GuiButtonHold(String name, Consumer<Integer> pressed) {
        super(name, pressed);
    }

    public GuiButtonHold(String name, int width, int height, Consumer<Integer> pressed) {
        super(name, width, height, pressed);
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        this.wait = System.currentTimeMillis();
        this.clicked = button;
        this.inital = true;
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        this.clicked = -1;
        super.mouseReleased(rect, x, y, button);
    }

    @Override
    public void tick() {
        if (this.clicked != -1) {
            if (this.inital) {
                if (System.currentTimeMillis() - this.wait >= 250L) {
                    this.pressed.accept(this.clicked);
                    this.wait = System.currentTimeMillis();
                    this.inital = false;
                }
            } else if (System.currentTimeMillis() - this.wait >= 100L) {
                this.pressed.accept(this.clicked);
                this.wait = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.clicked != -1 && !rect.inside(x, y)) {
            this.wait = System.currentTimeMillis();
        }
        super.mouseMoved(rect, x, y);
    }
}

