/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.handler;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.ContainerScreenIntegration;
import team.creative.creativecore.common.gui.sync.OpenGuiPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class GuiContainerHandler {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"creativecore");
    private static HashMap<String, GuiContainerHandler> guihandlers = new HashMap();
    MenuProvider provider;
    Supplier<MenuType<ContainerIntegration>> type;

    public static <T extends CreativePacket> void registerGuiHandler(String handlerid, final GuiHandlerPlayer handler) {
        guihandlers.put(handlerid, handler);
        handler.type = CONTAINERS.register(handlerid, () -> new MenuType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_, handler.create(playerInv.f_35978_));
            }

            public ContainerIntegration create(int windowId, Inventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_, handler.create(playerInv.f_35978_));
            }
        });
        handler.provider = new SimpleMenuProvider((id, inventory, player) -> {
            ContainerIntegration integration = new ContainerIntegration((MenuType<ContainerIntegration>)((MenuType)handler.type.get()), id, player, handler.create(player));
            return integration;
        }, (Component)new TextComponent(handlerid));
    }

    public static GuiContainerHandler getHandler(String id) {
        return guihandlers.get(id);
    }

    public static void openGui(Player player, String name) {
        GuiContainerHandler handler = GuiContainerHandler.getHandler(name);
        if (handler != null) {
            if (player.f_19853_.f_46443_) {
                CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(name));
            } else {
                player.m_5893_(handler.provider);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        for (GuiContainerHandler handler : guihandlers.values()) {
            MenuScreens.m_96206_(handler.type.get(), (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<ContainerIntegration, ContainerScreenIntegration>(){

                public ContainerScreenIntegration create(ContainerIntegration container, Inventory inventory, Component p_create_3_) {
                    return new ContainerScreenIntegration(container, inventory);
                }
            });
        }
    }

    public static abstract class GuiHandlerPlayer
    extends GuiContainerHandler {
        public abstract GuiLayer create(Player var1);
    }
}

