/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.level.CreativeLevel;

public class FakeChunkCache
extends ChunkSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LevelChunk emptyChunk;
    private final LevelLightEngine lightEngine;
    private volatile Storage storage;
    public final CreativeLevel level;

    public FakeChunkCache(CreativeLevel level, int radius) {
        this.level = level;
        this.emptyChunk = new EmptyLevelChunk((Level)level, new ChunkPos(0, 0));
        this.lightEngine = new LevelLightEngine((LightChunkGetter)this, true, level.m_6042_().m_63935_());
        this.storage = new Storage(FakeChunkCache.calculateStorageRange(radius));
    }

    public LevelLightEngine m_7827_() {
        return this.lightEngine;
    }

    private static boolean isValidChunk(@Nullable LevelChunk p_104439_, int p_104440_, int p_104441_) {
        if (p_104439_ == null) {
            return false;
        }
        ChunkPos chunkpos = p_104439_.m_7697_();
        return chunkpos.f_45578_ == p_104440_ && chunkpos.f_45579_ == p_104441_;
    }

    public void drop(int p_104456_, int p_104457_) {
        int i;
        LevelChunk levelchunk;
        if (this.storage.inRange(p_104456_, p_104457_) && FakeChunkCache.isValidChunk(levelchunk = this.storage.getChunk(i = this.storage.getIndex(p_104456_, p_104457_)), p_104456_, p_104457_)) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)levelchunk));
            this.storage.replace(i, levelchunk, null);
        }
    }

    @Nullable
    public LevelChunk getChunk(int p_104451_, int p_104452_, ChunkStatus p_104453_, boolean p_104454_) {
        LevelChunk levelchunk;
        if (this.storage.inRange(p_104451_, p_104452_) && FakeChunkCache.isValidChunk(levelchunk = this.storage.getChunk(this.storage.getIndex(p_104451_, p_104452_)), p_104451_, p_104452_)) {
            return levelchunk;
        }
        return p_104454_ ? this.emptyChunk : null;
    }

    public BlockGetter m_7653_() {
        return this.level;
    }

    @Nullable
    public LevelChunk replaceWithPacketData(int p_194117_, int p_194118_, FriendlyByteBuf p_194119_, CompoundTag p_194120_, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> p_194121_) {
        if (!this.storage.inRange(p_194117_, p_194118_)) {
            LOGGER.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_194117_, (Object)p_194118_);
            return null;
        }
        int i = this.storage.getIndex(p_194117_, p_194118_);
        LevelChunk levelchunk = this.storage.chunks.get(i);
        ChunkPos chunkpos = new ChunkPos(p_194117_, p_194118_);
        if (!FakeChunkCache.isValidChunk(levelchunk, p_194117_, p_194118_)) {
            levelchunk = new LevelChunk((Level)this.level, chunkpos);
            levelchunk.m_187971_(p_194119_, p_194120_, p_194121_);
            this.storage.replace(i, levelchunk);
        } else {
            levelchunk.m_187971_(p_194119_, p_194120_, p_194121_);
        }
        this.level.onChunkLoaded(chunkpos);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)levelchunk));
        return levelchunk;
    }

    public void m_142483_(BooleanSupplier p_104447_) {
    }

    public void updateViewCenter(int p_104460_, int p_104461_) {
        this.storage.viewCenterX = p_104460_;
        this.storage.viewCenterZ = p_104461_;
    }

    public void updateViewRadius(int p_104417_) {
        int i = this.storage.chunkRadius;
        int j = FakeChunkCache.calculateStorageRange(p_104417_);
        if (i != j) {
            Storage clientchunkcache$storage = new Storage(j);
            clientchunkcache$storage.viewCenterX = this.storage.viewCenterX;
            clientchunkcache$storage.viewCenterZ = this.storage.viewCenterZ;
            for (int k = 0; k < this.storage.chunks.length(); ++k) {
                LevelChunk levelchunk = this.storage.chunks.get(k);
                if (levelchunk == null) continue;
                ChunkPos chunkpos = levelchunk.m_7697_();
                if (!clientchunkcache$storage.inRange(chunkpos.f_45578_, chunkpos.f_45579_)) continue;
                clientchunkcache$storage.replace(clientchunkcache$storage.getIndex(chunkpos.f_45578_, chunkpos.f_45579_), levelchunk);
            }
            this.storage = clientchunkcache$storage;
        }
    }

    private static int calculateStorageRange(int p_104449_) {
        return Math.max(2, p_104449_) + 3;
    }

    public String m_6754_() {
        return this.storage.chunks.length() + ", " + this.m_142061_();
    }

    public int m_142061_() {
        return this.storage.chunkCount;
    }

    public void m_6506_(LightLayer p_104436_, SectionPos p_104437_) {
        Minecraft.m_91087_().f_91060_.m_109770_(p_104437_.m_123170_(), p_104437_.m_123206_(), p_104437_.m_123222_());
    }

    public void addEntity(Entity p_143371_) {
    }

    public void removeEntity(Entity p_143375_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    final class Storage {
        private final AtomicReferenceArray<LevelChunk> chunks;
        private final int chunkRadius;
        private final int viewRange;
        private volatile int viewCenterX;
        private volatile int viewCenterZ;
        private int chunkCount;

        Storage(int p_104474_) {
            this.chunkRadius = p_104474_;
            this.viewRange = p_104474_ * 2 + 1;
            this.chunks = new AtomicReferenceArray(this.viewRange * this.viewRange);
        }

        int getIndex(int p_104482_, int p_104483_) {
            return Math.floorMod(p_104483_, this.viewRange) * this.viewRange + Math.floorMod(p_104482_, this.viewRange);
        }

        protected void replace(int p_104485_, @Nullable LevelChunk p_104486_) {
            LevelChunk levelchunk = this.chunks.getAndSet(p_104485_, p_104486_);
            if (levelchunk != null) {
                --this.chunkCount;
                FakeChunkCache.this.level.unload(levelchunk);
            }
            if (p_104486_ != null) {
                ++this.chunkCount;
            }
        }

        protected LevelChunk replace(int p_104488_, LevelChunk p_104489_, @Nullable LevelChunk p_104490_) {
            if (this.chunks.compareAndSet(p_104488_, p_104489_, p_104490_) && p_104490_ == null) {
                --this.chunkCount;
            }
            FakeChunkCache.this.level.unload(p_104489_);
            return p_104489_;
        }

        boolean inRange(int p_104501_, int p_104502_) {
            return Math.abs(p_104501_ - this.viewCenterX) <= this.chunkRadius && Math.abs(p_104502_ - this.viewCenterZ) <= this.chunkRadius;
        }

        @Nullable
        protected LevelChunk getChunk(int p_104480_) {
            return this.chunks.get(p_104480_);
        }
    }
}

