/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.level.CreativeLevel;
import team.creative.creativecore.common.level.FakeLevelInfo;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class FakeLevel
extends CreativeLevel {
    public MinecraftServer server;
    public IVecOrigin origin;
    private final Scoreboard scoreboard = new Scoreboard();
    private DimensionSpecialEffects effects;
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender;

    public static FakeLevel createFakeWorld(MinecraftServer server, String name, boolean client) {
        FakeLevelInfo info = new FakeLevelInfo(Difficulty.PEACEFUL, false, true);
        if (!client) {
            return new FakeLevel(info, 6, () -> ((MinecraftServer)server).m_129905_(), false, false, 0L);
        }
        return FakeLevel.createFakeWorldClient(name, info, 6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FakeLevel createFakeWorldClient(String name, FakeLevelInfo info, int radius) {
        return new FakeLevel(info, radius, () -> ((Minecraft)Minecraft.m_91087_()).m_91307_(), true, false, 0L);
    }

    protected FakeLevel(WritableLevelData worldInfo, int radius, Supplier<ProfilerFiller> supplier, boolean client, boolean debug, long seed) {
        super(worldInfo, radius, supplier, client, debug, seed);
        if (client) {
            this.effects = DimensionSpecialEffects.m_108876_((DimensionType)this.m_6042_());
        }
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vec3d vec) {
        this.origin = new VecOrigin(vec);
    }

    public boolean hasParent() {
        return false;
    }

    public Level getParent() {
        return null;
    }

    public Level getRealLevel() {
        return null;
    }

    public Biome m_6159_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return (Biome)this.m_5962_().m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_);
    }

    public float m_7717_(Direction p_230487_1_, boolean p_230487_2_) {
        boolean flag = this.effects.m_108885_();
        if (!p_230487_2_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_230487_1_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public void m_6263_(Player p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
    }

    public void m_6269_(Player p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundSource p_217384_4_, float p_217384_5_, float p_217384_6_) {
    }

    public Scoreboard m_6188_() {
        return this.scoreboard;
    }

    public RecipeManager m_7465_() {
        if (this.f_46443_) {
            return Minecraft.m_91087_().m_91403_().m_105141_();
        }
        return this.m_142572_().m_129894_();
    }

    public TagContainer m_5999_() {
        if (this.f_46443_) {
            return Minecraft.m_91087_().m_91403_().m_105148_();
        }
        return this.m_142572_().m_129895_();
    }

    public void m_5898_(Player p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public RegistryAccess m_5962_() {
        if (this.f_46443_) {
            return Minecraft.m_91087_().m_91403_().m_105152_();
        }
        return this.m_142572_().m_129911_();
    }

    public void m_142346_(Entity p_151549_, GameEvent p_151550_, BlockPos p_151551_) {
    }
}

