/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    private static PairList<String, GuiCreativeIngredientHandler> handlers = new PairList();
    public static GuiCreativeIngredientHandler defaultHandler = new GuiCreativeIngredientHandler(){

        @Override
        public void createControls(GuiParent gui, CreativeIngredient info) {
            GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
            gui.add(selector);
            gui.add(new GuiLabel("guilabel1"));
            gui.add(new GuiLabel("guilabel2"));
            GuiStateButton damage = new GuiStateButton("damage", 0, new TextListBuilder().add("Damage: Off", "Damage: On"));
            gui.add(damage);
            GuiStateButton nbt = new GuiStateButton("nbt", 0, new TextListBuilder().add("NBT: Off", "NBT: On"));
            gui.add(nbt);
            if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                selector.setSelectedForce(info.getExample().m_41777_());
                if (info instanceof CreativeIngredientItemStack) {
                    damage.nextState();
                    if (((CreativeIngredientItemStack)info).needNBT) {
                        nbt.nextState();
                    }
                }
            }
            this.onChanged(gui, new GuiControlChangedEvent(selector));
        }

        @Override
        public boolean canHandle(CreativeIngredient info) {
            return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
        }

        @Override
        public CreativeIngredient parseControls(GuiParent gui) {
            ItemStack stack = ((GuiStackSelector)gui.get("inv")).getSelected();
            if (stack != null) {
                boolean nbt;
                boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                if (damage) {
                    return new CreativeIngredientItemStack(stack.m_41777_(), nbt);
                }
                if (!(Block.m_49814_((Item)stack.m_41720_()) instanceof AirBlock)) {
                    return new CreativeIngredientBlock(Block.m_49814_((Item)stack.m_41720_()));
                }
                return new CreativeIngredientItem(stack.m_41720_());
            }
            return null;
        }

        @Override
        public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
            GuiStackSelector selector;
            if (event.control.is("inv") && (selector = (GuiStackSelector)event.control) != null) {
                ItemStack stack = selector.getSelected();
                if (!stack.m_41619_()) {
                    ((GuiLabel)gui.get("guilabel1")).setTitle((Component)new TextComponent("damage: " + stack.m_41773_()));
                    ((GuiLabel)gui.get("guilabel2")).setTitle((Component)new TextComponent("nbt: " + stack.m_41783_()));
                } else {
                    ((GuiLabel)gui.get("guilabel1")).setTitle((Component)new TextComponent(""));
                    ((GuiLabel)gui.get("guilabel2")).setTitle((Component)new TextComponent(""));
                }
            }
        }
    };
    private String name;

    public static void registerGuiInfoHandler(String name, GuiCreativeIngredientHandler handler) {
        handler.name = name;
        handlers.add(name, handler);
    }

    public static int indexOf(String name) {
        return handlers.indexOfKey(name);
    }

    public static GuiCreativeIngredientHandler get(int index) {
        return (GuiCreativeIngredientHandler)((Pair)GuiCreativeIngredientHandler.handlers.get((int)index)).value;
    }

    public static Set<String> getNames() {
        return handlers.keys();
    }

    public static GuiCreativeIngredientHandler getHandler(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : handlers.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return defaultHandler;
    }

    public static GuiCreativeIngredientHandler getHandler(String name) {
        GuiCreativeIngredientHandler handler = handlers.getValue(name);
        if (handler == null) {
            return defaultHandler;
        }
        return handler;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Default", defaultHandler);
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Material", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                Block block;
                ItemStack blockStack = ((GuiStackSelector)gui.get("inv")).getSelected();
                if (blockStack != null && !((block = Block.m_49814_((Item)blockStack.m_41720_())) instanceof AirBlock)) {
                    return new CreativeIngredientMaterial(block.m_49966_().m_60767_());
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                GuiStackSelector selector = new GuiStackSelector("inv", null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.GuiBlockSelector()));
                selector.setExpandableX();
                gui.add(selector);
                if (info instanceof CreativeIngredientMaterial) {
                    selector.setSelectedForce(info.getExample());
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientMaterial;
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                Tag tag = (Tag)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((Tag<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<Tag<Block>> box = new GuiComboBoxMapped<Tag<Block>>("tag", new TextMapBuilder<Tag>().addComponents(BlockTags.m_13115_().m_5643_().values(), x -> {
                    TextBuilder builder = new TextBuilder();
                    if (x.m_6497_().size() > 0) {
                        builder.stack(new ItemStack((ItemLike)x.m_6497_().get(0)));
                    }
                    return builder.text(BlockTags.m_13115_().m_7473_(x).toString()).build();
                }));
                gui.add(box);
                gui.add(new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BlockTags.m_13115_().m_5643_().values(), x -> new TextBuilder().stack(new ItemStack((ItemLike)x.m_6497_().get(0))).text(BlockTags.m_13115_().m_7473_(x).toString()).build()));
                }
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                Tag tag = (Tag)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((Tag<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBoxMapped<Tag<Item>> box = new GuiComboBoxMapped<Tag<Item>>("tag", new TextMapBuilder<Tag>().addComponents(ItemTags.m_13193_().m_5643_().values(), x -> new TextBuilder().stack(new ItemStack((ItemLike)x.m_6497_().get(0))).text(ItemTags.m_13193_().m_7473_(x).toString()).build()));
                gui.add(box);
                gui.add(new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(ItemTags.m_13193_().m_5643_().values(), x -> new TextBuilder().stack(new ItemStack((ItemLike)x.m_6497_().get(0))).text(ItemTags.m_13193_().m_7473_(x).toString()).build()));
                }
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add(new GuiLabel("info").setTitle((Component)new TextComponent("Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }
}

